***
*** SCOLOR.PRG
***	07/18/88
*** by Mary Matthews, CIS 76010,3546
*** Link with CLIPPER, EXTEND & PROCLIP2
*** 
*** The program uses SCOLOR.MEM if there is one in the current directory.
*** Menu choice "Save" saves the currently displayed colors to 
*** 	NCOLOR.MEM and appends them to NCOLOR.TXT
*** A deficiency is that it overwrites a current NCOLOR.MEM file - 
*** NCOLOR.TXT will be created if it does not exist. 
*** NCOLOR.TXT is for use with an editor.
*** 
doscolor = getcolor(0,0)
dosscreen = savebox(0,0,24,79)
doscursor = savecurs()
cursor('off')
set scoreboard off
set console off
set color to w/n
declare aMenu[7],aDesc[7],aCol[7],aClr[16]
aMenu[1] = "Normal"
aMenu[2] = "Fields"
aMenu[3] = "InfoBox"
aMenu[4] = "ErrorBox"
aMenu[5] = "ChoiceBox"
aMenu[6] = "Save"
aMenu[7] = "Quit"
aDesc[1] = "Change screen background, text, frame.              "
aDesc[2] = "Change selected, unselected fields.                 "
aDesc[3] = "Change InfoBox background, text, frame.             "
aDesc[4] = "Change ErrorBox background, text, frame.            "
aDesc[5] = "Change ChoiceBox background, text, frame, highlight."
aDesc[6] = "Save displayed colors to disk file.                 "
aDesc[7] = "Exit to DOS.                                        "
aKeys = "NFIECSQ"
aCol[1] = 0
aCol[2] = 8
aCol[3] = 16
aCol[4] = 25
aCol[5] = 35
aCol[6] = 46
aCol[7] = 52

aClr[1] = "n"
aClr[2] = "b"
aClr[3] = "g"
aClr[4] = "r"
aClr[5] = "bg"
aClr[6] = "rb"
aClr[7] = "gr"
aClr[8] = "w"
aClr[9] = "+n"
aClr[10] = "+b"
aClr[11] = "+g"
aClr[12] = "+r"
aClr[13] = "+bg"
aClr[14] = "+rb"
aClr[15] = "+gr"
aClr[16] = "+w"

if file("scolor.mem")
	restore from scolor additive
else
	** regular screen colors
	clrNF = 'n'
	clrNB = 'bg'
	** regular screen frame/border colors
	clrNFX = 'n'
	clrNBX = 'bg'
	** selected field colors
	clrSF = '+w'
	clrSB = 'b'
	** unselected fields colors
	clrUF = '+gr'
	clrUB = 'bg'
	** information/directions box contents colors
	clrIF = 'w'
	clrIB = 'b'
	** information/directions box frame colors
	clrIFX = 'w'
	clrIBX = 'b'
	** error box contents colors
	clrEF = '+w'
	clrEB = 'gr'
	** error box frame colors
	clrEFX = '+w'
	clrEBX = 'gr'
	** choice box contents colors
	clrCF =	'w'
	clrCB =	'b'
	** choice box frame colors
	clrCFX = '+w'
	clrCBX = 'b'
	** choice box highlighted colors
	clrHF = '+w'
	clrHB = 'g'
endif
** Clipper color string
new = 1
old = new
clear
** initial display
sprint(0,0,"Normal  Fields  InfoBox  ErrorBox  ChoiceBox  Save  Quit")
newcolor(0,aCol[new],0,aCol[new]+len(aMenu[new])-1,'+w/w')
sprint(1,aCol[new],aDesc[new],'+w/n')

** color choices box
@ 2,67,21,79 box "Ŀ "
sprint(3,68,"Back   Fore",'+w/n')
@ 4,68,""
for i = 1 to 8
	sprint(i+4,68,"",aClr[i])
	sprint(i+4,75,"",aClr[i])
next
for i = 9 to 16
	sprint(i+4,75,"",aClr[i])
next

** normal/regular screen and frame
set color to (clrNF+'/'+clrNB)
@ 2,0,24,65 box "ͻȺ "
boxcolor(2,0,24,65,clrNFX+'/'+clrNBX)

** normal/regular text
sprint(16,5,"Customer Update")
sprint(17,5,"")
sprint(18,5,"Last Name:")
sprint(18,33,"First Name:")
sprint(19,7,"Address:")
sprint(21,10,"City:")
sprint(21,33,"St:")
sprint(21,40,"Zip:")
sprint(22,5,"Telephone:")

** infobox
set color to (clrIF+'/'+clrIB)
@ 4,4,6,31 box "ͻȺ "
boxcolor(4,4,6,31,clrIFX+'/'+clrIBX)
sprint(5,7,"Information/Directions")

** errorbox
set color to (clrEF+'/'+clrEB)
@ 6,40,8,61 box "Ŀ "
boxcolor(6,40,8,61,clrEFX+'/'+clrEBX)
sprint(7,43,"Error Message!!!")

** choicebox
set color to (clrCF+'/'+clrCB)
@ 10,13,14,51 box "ͻȺ "
boxcolor(10,13,14,51,clrCFX+'/'+clrCBX)
sprint(11,14," Jones,Jennifer         303-750-3241 ",clrHF+'/'+clrHB)
sprint(12,15,"Smith,Fred             214-777-1234")
sprint(13,15,"Thomas,Kelly           303-234-4321")

** fields
clr = clrUF+'/'+clrUB
* selected field
sprint(18,16,"Jones...........",clrSF+'/'+clrSB)
* unselected fields
sprint(18,45,"Jennifer.......",clr)
sprint(19,16,"1234 South Avenue...............",clr)
sprint(20,16,"Suite 404.......................",clr)
sprint(21,16,"Anywhere........",clr)
sprint(21,37,"CO",clr)
sprint(21,45,"80123-1011",clr)
sprint(22,16,"(303) 750-3241",clr)

do while .t.
	ch = upper(chr(inkey(0)))
	if lastkey() == 4
		new = if(old < len(aMenu),old+1,1)
	elseif lastkey() == 19
		new = if(old > 1,old-1,len(aMenu))
	elseif lastkey() == 13
		if new == len(aMenu)
			exit
		elseif new == len(aMenu)-1
			do CLRSAVE
		else
			DOCHOICE(new)
		endif
	elseif ch $ aKeys
		new = at(ch,aKeys)
	elseif lastkey() == 27
		new = len(aMenu)
	endif
	if new != old
		newcolor(0,aCol[old],0,aCol[old]+len(aMenu[old])-1,'w/n')
		newcolor(0,aCol[new],0,aCol[new]+len(aMenu[new])-1,'+w/w')
		sprint(1,0,aDesc[new],'+w/n')
		old = new
	endif
enddo
set color to (doscolor)
restbox(dosscreen)
restcurs(doscursor)
cursor('std')
quit



function DOCHOICE
parameters wh
private ch, mnusav, oldscn, newopt, oldopt
mnusav = savebox(0,0,1,79)
newcolor(0,aCol[wh],0,aCol[wh]+len(aMenu[wh])-1,'+w/n')
oldopt = 1
newopt = 1
do case
case wh == 1
** normal/regular screen, text and frame
	oldscn = savebox(2,0,24,65)
	colF = clrNF
	colB = clrNB
	private pick[2]
	pick[1] = "Screen"
	pick[2] = "Frame"
	sprint(1,0,space(65))
	sprint(1,26,pick[1]+'  '+pick[2],'+w/n')
	newcolor(1,26,1,31,'+w/w')
	@ 1,26,''
	do while .t.
		cursor('std')
		ch = upper(chr(inkey(0)))
		cursor('off')
		do case
		case lastkey() == 4
			newopt = if(oldopt == 1,2,1)
		case lastkey() == 19
			newopt = if(oldopt == 1,2,1)
		case ch $ "SF"
			newopt = at(ch,"SF")
			keyboard chr(13)
		case lastkey() == 13
			colF = if(newopt == 1,clrNF,clrNFX)
			colB = if(newopt == 1,clrNB,clrNBX)
			lkey = SELECLR()
			if lkey == 27
				restbox(oldscn)
			else
				if newopt == 1
					clrNF = colF
					clrNB = colB
				else
					clrNFX = colF
					clrNBX = colB
				endif
				oldscn = savebox(2,0,24,65)
			endif
		case lastkey() == 27
			exit
		endcase
		if newopt != oldopt
			if oldopt == 1
				newcolor(1,26,1,31,'+w/n')
				newcolor(1,34,1,38,'+w/w')
				@ 1,34,''
			else
				newcolor(1,34,1,38,'+w/n')
				newcolor(1,26,1,31,'+w/w')
				@ 1,26,''
			endif
			oldopt = newopt
		endif
	enddo

case wh == 2
** selected field or unselected fields
	private pick[2]
	pick[1] = "Selected"
	pick[2] = "Unselected"
	sprint(1,0,space(65))
	sprint(1,23,pick[1]+'  '+pick[2],'+w/n')
	newcolor(1,23,1,30,'+w/w')
	@ 1,23,''
	do while .t.
		cursor('std')
		ch = upper(chr(inkey(0)))
		cursor('off')
		do case
		case lastkey() == 4
			newopt = if(oldopt == 1,2,1)
		case lastkey() == 19
			newopt = if(oldopt == 1,2,1)
		case ch $ "SU"
			newopt = at(ch,"SU")
			keyboard chr(13)
		case lastkey() == 13
			colF = if(newopt == 1,clrSF,clrUF)
			colB = if(newopt == 1,clrSB,clrUB)
			lkey = SELECLR()
			if lkey == 27
				if newopt == 2
					clr = clrUF+'/'+clrUB
					newcolor(18,45,18,59,clr)
					newcolor(19,16,20,47,clr)
					newcolor(21,16,21,31,clr)
					newcolor(21,37,21,38,clr)
					newcolor(21,45,21,54,clr)
					newcolor(22,16,22,29,clr)
				else
					newcolor(18,16,18,31,clrSF+'/'+clrSB)
				endif
			else
				if newopt == 1
					clrSF = colF
					clrSB = colB
				else
					clrUF = colF
					clrUB = colB
				endif
			endif
		case lastkey() == 27
			exit
		endcase
		if newopt != oldopt
			if oldopt == 1
				newcolor(1,23,1,30,'+w/n')
				newcolor(1,33,1,42,'+w/w')
				@ 1,33,''
			else
				newcolor(1,33,1,42,'+w/n')
				newcolor(1,23,1,30,'+w/w')
				@ 1,23,''
			endif
			oldopt = newopt
		endif
	enddo
	
case wh == 3
** information/description message and box
	oldscn = savebox(4,4,6,31)
	private pick[2]
	pick[1] = "Contents"
	pick[2] = "Frame"
	sprint(1,0,space(65))
	sprint(1,26,pick[1]+'  '+pick[2],'+w/n')
	newcolor(1,26,1,33,'+w/w')
	@ 1,26,''
	do while .t.
		cursor('std')
		ch = upper(chr(inkey(0)))
		cursor('off')
		do case
		case lastkey() == 4
			newopt = if(oldopt == 1,2,1)
		case lastkey() == 19
			newopt = if(oldopt == 1,2,1)
		case ch $ "CF"
			newopt = at(ch,"CF")
			keyboard chr(13)
		case lastkey() == 13
			colF = if(newopt == 1,clrIF,clrIFX)
			colB = if(newopt == 1,clrIB,clrIBX)
			lkey = SELECLR()
			if lkey == 27
				restbox(oldscn)
			else
				if newopt == 1
					clrIF = colF
					clrIB = colB
				else
					clrIFX = colF
					clrIBX = colB
				endif
				oldscn = savebox(4,4,6,31)
			endif
		case lastkey() == 27
			exit
		endcase
		if newopt != oldopt
			if oldopt == 1
				newcolor(1,26,1,33,'+w/n')
				newcolor(1,36,1,40,'+w/w')
				@ 1,36,''
			else
				newcolor(1,36,1,40,'+w/n')
				newcolor(1,26,1,33,'+w/w')
				@ 1,26,''
			endif
			oldopt = newopt
		endif
	enddo

case wh == 4
** error message and box
	oldscn = savebox(6,40,8,61)
	private pick[2]
	pick[1] = "Contents"
	pick[2] = "Frame"
	sprint(1,0,space(65))
	sprint(1,26,pick[1]+'  '+pick[2],'+w/n')
	newcolor(1,26,1,33,'+w/w')
	@ 1,26,''
	do while .t.
		cursor('std')
		ch = upper(chr(inkey(0)))
		cursor('off')
		do case
		case lastkey() == 4
			newopt = if(oldopt == 1,2,1)
		case lastkey() == 19
			newopt = if(oldopt == 1,2,1)
		case ch $ "CF"
			newopt = at(ch,"CF")
			keyboard chr(13)
		case lastkey() == 13
			colF = if(newopt == 1,clrEF,clrEFX)
			colB = if(newopt == 1,clrEB,clrEBX)
			lkey = SELECLR()
			if lkey == 27
				restbox(oldscn)
			else
				if newopt == 1
					clrEF = colF
					clrEB = colB
				else
					clrEFX = colF
					clrEBX = colB
				endif
				oldscn = savebox(6,40,8,61)
			endif
		case lastkey() == 27
			exit
		endcase
		if newopt != oldopt
			if oldopt == 1
				newcolor(1,26,1,33,'+w/n')
				newcolor(1,36,1,40,'+w/w')
				@ 1,36,''
			else
				newcolor(1,36,1,40,'+w/n')
				newcolor(1,26,1,33,'+w/w')
				@ 1,26,''
			endif
			oldopt = newopt
		endif
	enddo

case wh == 5
** choice text, box and highlight
	oldscn = savebox(10,13,14,51)
	private pick[3]
	pick[1] = "Contents"
	pick[2] = "Frame"
	pick[3] = "Highlight"
	sprint(1,0,space(65))
	sprint(1,20,pick[1]+'  '+pick[2]+'  '+pick[3],'+w/n')
	newcolor(1,20,1,27,'+w/w')
	@ 1,20,''
	do while .t.
		cursor('std')
		ch = upper(chr(inkey(0)))
		cursor('off')
		do case
		case lastkey() == 4
			newopt = if(oldopt < 3, oldopt+1, 1)
		case lastkey() == 19
			newopt = if(oldopt > 1, oldopt-1, 3)
		case ch $ "CFH"
			newopt = at(ch,"CFH")
			keyboard chr(13)
		case lastkey() == 13
			colF = if(newopt == 1,clrCF,if(newopt == 2,clrCFX,clrHF))
			colB = if(newopt == 1,clrCB,if(newopt == 2,clrCBX,clrHB))
			lkey = SELECLR()
			if lkey == 27
				restbox(oldscn)
			else
				if newopt == 1
					clrCF = colF
					clrCB = colB
				elseif newopt == 2
					clrCFX = colF
					clrCBX = colB
				else
					clrHF = colF
					clrHB = colB
				endif
				oldscn = savebox(10,13,14,51)
			endif
		case lastkey() == 27
			exit
		endcase
		if newopt != oldopt
			if oldopt == 1
				newcolor(1,20,1,27,'+w/n')
			elseif oldopt == 2
				newcolor(1,30,1,34,'+w/n')
			elseif oldopt == 3
				newcolor(1,37,1,45,'+w/n')
			endif
			if newopt == 1
				newcolor(1,20,1,27,'+w/w')
				@ 1,20,''
			elseif newopt == 2
				newcolor(1,30,1,34,'+w/w')
				@ 1,30,''
			elseif newopt == 3
				newcolor(1,37,1,45,'+w/w')
				@ 1,37,''
			endif
			oldopt = newopt
		endif
	enddo
endcase
restbox(mnusav)
return ''


function SELECLR
private ch, retval
retval = ""
fore = .t.
back = .f.
colF0 = colF
colB0 = colB
place = if(fore,ascan(aClr,colF),ascan(aClr,colB))
limit = if(fore,16,8)
do while .t.
	point( if(fore,"",""),place )
	ch = upper(chr(inkey(0)))
	point("  ",place)
	if lastkey() == 5 .or. lastkey() == 24
		place = if(lastkey() == 5,if(place > 1, place - 1, limit),;
			if(place < limit, place + 1, 1) ) 
		colF = if(fore,aClr[place],colF)
		colB = if(back,aClr[place],colB)
		DOCHANGE(wh,newopt)
	elseif lastkey() == 19 .or. lastkey() == 4
		fore = if(fore,.f.,.t.)
		back = !(fore)
		limit = if(fore,16,8)
		place = if(fore,ascan(aClr,colF),ascan(aClr,colB,1,8))
		colF = if(fore,aClr[place],colF)
		colB = if(back,aClr[place],colB)
	elseif lastkey() == 27
		retval = 27
		colF = colF0
		colB = colB0
		exit
	elseif lastkey() == 13
		retval = 13
		exit
	else
		clear typeahead
		sound(460,4,.f.)
		sound(360,5,.f.)
	endif
enddo
return retval


function DOCHANGE
parameters which,what
do case
case which == 1
** normal screen, text and frame
	do case
	case what == 1
	*** change normal screen colors
		if back
			** save the boxes
			box1 = savebox(4,4,6,31)
			box2 = savebox(6,40,8,61)
			box3 = savebox(10,13,14,51)
			** change the screen colors
			newcolor(3,1,23,64,colF+'/'+aClr[place])
			** restore the boxes
			restbox(box1)
			restbox(box2)
			restbox(box3)
			** restore selected field color
			newcolor(18,16,18,31,clrSF+'/'+clrSB)
			** restore unselected fields color
			clr = clrUF+'/'+clrUB
			newcolor(18,45,18,59,clr)
			newcolor(19,16,20,47,clr)
			newcolor(21,16,21,31,clr)
			newcolor(21,37,21,38,clr)
			newcolor(21,45,21,54,clr)
			newcolor(22,16,22,29,clr)
		else
		*** must be foreground
			clr = aClr[place]+'/'+colB
			*** change regular text colors foreground
			newcolor(16,5,16,19,clr)
			newcolor(17,5,17,59,clr)
			newcolor(18,5,18,14,clr)
			newcolor(18,33,18,43,clr)
			newcolor(19,7,19,14,clr)
			newcolor(21,10,21,14,clr)
			newcolor(21,33,21,35,clr)
			newcolor(21,40,21,43,clr)
			newcolor(22,5,22,14,clr)
		endif
	*** change normal screen frame
	case what == 2
		boxcolor(2,0,24,65,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	endcase

case which == 2
*** field colors
	if what == 1
	** change selected field
		newcolor(18,16,18,31,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	else
	** change unselected fields
		clr = if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place])
		newcolor(18,45,18,59,clr)
		newcolor(19,16,20,47,clr)
		newcolor(21,16,21,31,clr)
		newcolor(21,37,21,38,clr)
		newcolor(21,45,21,54,clr)
		newcolor(22,16,22,29,clr)
	endif

case which == 3
*** info box
	do case
	case what == 1
	*** change info text color
		newcolor(5,5,5,30,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	case what == 2
	*** change info box frame colors
		boxcolor(4,4,6,31,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	endcase

case which == 4
*** error box
	do case
	case what == 1
	*** change err text color
		newcolor(7,41,7,60,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	case what == 2
	*** change err box frame
		boxcolor(6,40,8,61,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	endcase

case which == 5
*** choice box
	do case
	case what == 1
	*** change contents colors
		newcolor(12,14,13,50,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	case what == 2
	*** change choice box frame
		boxcolor(10,13,14,51,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	case what == 3
	*** change hilite colors
		newcolor(11,14,11,50,if(fore,aClr[place]+'/'+colB,colF+'/'+aClr[place]))
	endcase

endcase
return ''


function Point
parameters ptr,place
sprint(4+place,if(fore,73,72),ptr,'+w/n')
return ""


procedure CLRSAVE
set escape off
** Basic Clipper color string for
**	Normal screen, selected field, normal screen frame, unselected fields
colSTR = ;
 clrNF+'/'+clrNB+','+clrSF+'/'+clrSB+','+clrNFX+'/'+clrNBX+',,'+clrUF+'/'+clrUB
** Colors for InfoBox contents
colINF = clrIF+'/'+clrIB
** Colors for InfoBox frame
colINFX = clrIFX+'/'+clrIBX
** Colors for ErrorBox contents
colERR = clrEF+'/'+clrEB
** Colors for ErrorBox frame
colERRX = clrEFX+'/'+clrEBX
** Colors for ChoiceBox contents
colCHC = clrCF+'/'+clrCB
** Colors for ChoiceBox frame
colCHCX = clrCFX+'/'+clrCBX
** Colors for Highlight bar in ChoiceBox
colHIH = clrHF+'/'+clrHB
save to NCOLOR all like col*
save to SCOLOR all like clr*
fbuffer = chr(13)+chr(10)+;
		  "colSTR  = "+colSTR+chr(13)+chr(10)+;
		  "colINF  = "+colINF+chr(13)+chr(10)+;
		  "colINFX = "+colINFX+chr(13)+chr(10)+;
		  "colERR  = "+colERR+chr(13)+chr(10)+;
		  "colERRX = "+colERRX+chr(13)+chr(10)+;
		  "colCHC  = "+colCHC+chr(13)+chr(10)+;
		  "colCHCX = "+colCHCX+chr(13)+chr(10)+;
		  "colHIH  = "+colHIH+chr(13)+chr(10)

fhandle = fopen("NCOLOR.TXT",2)
if ferror() != 0
	fhandle = fcreate("NCOLOR.TXT")
end
if ferror() != 0
	do fERRMSG
else
	fseek(fhandle,0,2)
	fwrite(fhandle,fbuffer)
	if ferror() != 0
		do fERRMSG
	end
	fclose(fhandle)
end
set escape on
return


procedure fERRMSG
private winbuff
set color to +w/bg
sound(400,4,.f.)
sound(300,3,.f.)
sound(400,4,.f.)
winbuff = savebox(14,12,17,66)
@ 14,12,17,66 box "ͻȺ "
@ 15,14 say "Unable to open/create file NCOLOR.TXT, DOS error "+;
	str(ferror(),2)
@ 16,14 say "Press any key to continue."
inkey(0)
set color to w/n
restbox(winbuff)
return

* eof
