
/* The program demonstrates the functions in the SCBREP library. When run,
 it displays a simple menu. From here you can either edit or add records.*/


/* Opens the orders2  database. Orders2  is just for demonstrating the Reccopy()
function */

use orders2 new

/*Opens orders */
use orders new

// Opens the cust database. Cust contains a customer list.
use cust new

//Creates the index for cust
if !file("custno.ntx")
  index on custno to custno
endif

set index to custno

cc:=" "

do while .T.
clear

 @3,1 say "Menu"
 @5,1 say "E-Edit data"
 @6,1 say "A-Add new data"
 @7,1 say "Q-Quit"
 @8,1 say "R-Copy record to other database"
 @9,1 say "Enter choice " get cC
 read

 cc=upper(cc)

do case

    /* If the R option is selected, Reccopy copies a selected record from orders
     to the orders2 database */

    case cc="R"
     select orders
     @ 1,0 say "Select record you wish to copy and press Enter "
     dbedit(2,0,24,79)
     select orders2
     append blank
     Reccopy("orders2","orders")


     /* Adds a new order. Calls neworder to initialize a order date field then
      calls addorder to actually display/edit GETs. The "n" parameter indicates
      the GET fields created will be prefixed with "n" */

    case cc="A"
     select orders
     moddata("A",{||neworder()},{|cMode|addorder(cMode)},"n")


    case cc="E"
     select orders
     @ 1,0 say "Select record you wish to edit and press Enter "
     dbedit(2,0,24,79)
     moddata("E",,{|cMode|addorder(cMode)},"n")

    case cc="Q"
      quit
endcase

enddo

/* This function is called from the moddata function. The cMode parameter
is passed from moddata(). If cMode is "A", then it is add mode, if "E" it is in
edit mode. If the function returns .T. to moddata(), then moddata() will add a
new order record and fill in the blanks. If the function returns .F., it will
do nothing*/


function addorder(cMode)

clear
 @1,1 say "Order#    " get nordernum
 @2,1 say "Customer# " get ncustno valid chknum()
 @2,18  say "Enter customer# between 1-4"
 @3,1 say "Order date: " get nOdate when cMode="A" // Allows access to date only when adding
 @4,1 say "Name      " get nname when .F.
 @5,1 say "Address   " get naddress1 when .F.
 @6,1 say "          " get naddress2 when .F.
 @7,1 say "Phone     " get nphone when .F.
 @8,1 say "Total     " get ntotal

read

if lastkey()=27
  return(.F.)
endif

return(.T.)

/* This is called for a new order record. Assigns order date as todays date*/

function neworder
  nOdate:=date()
return NIL


/* The chknum function simply validates if the customer number you have
entered is valid. If it is, it calls repdup, which fills in all of the
corresponding field names*/

function chknum

select cust
// Looks for the customer number in the ncustno field
seek(getactive():varget())

/* Does this customer exist? If so, fill in the fields with the same same and
 redisplay the GETS */
if found()

 /* Copy values from CUST database into orders with fields with same name.
 The "N" parameter tells it to take the first character off the GET variable
 before comparing to the database fields */
 repdup("N")

 // Redisplay the GETs
 redisp()
 select orders // Make sure we get back to the original database...
 return(.T.)
endif

select orders
return(.F.)


