;	Title:	ROLLSCRN.ASM
;	Author:	F. Ho
;	Date:	sometime 1985
;	Syntax:	DO ROLLUP WITH 1,2,3,4
;			DO ROLLDN WITH 1,2,3,4
;	Note:	- rollup = rolls UP that part of the screen specified by 
;			  the coordinates
;			- rolldn = rolls DOWN that part of the screen specified 
;			  by the coordinates
;
public	ROLLUP					; declare as public
public	ROLLDN					;
;
extrn	_PARNI:far				; declare as external of type far
extrn	_RET:far					;
;
;
datasg	segment	para	'DATA'		; start of data segment
;
TOP		db	0h					; top -
LEFT	db	0h					; left corner
BOTTOM	db	0h					; bottom -
RIGHT	db	0h					; right corner
;
datasg	ends						; end of data segment
;
;
_prog	segment	byte				; start of code segment
assume	cs:_prog,ds:datasg,es:_prog
;
ROLLUP	proc	far					; start of ROLLUP process
		push	bp					; preserve return address
		mov	bp,sp

		push	ds					; save registers
		push	es					;

		mov	ax,1					; take 1st para
		push	ax
		call	_PARNI
		add	sp,2					; restore stack
		mov	TOP,al				; assign 1st para to TOP

		mov	ax,2					; take 2nd para
		push	ax
		call	_PARNI
		add	sp,2
		mov	LEFT,al				; assign to LEFT
	
		mov	ax,3					; take 3rd para
		push	ax
		call	_PARNI
		add	sp,2
		mov	BOTTOM,al				; assign to BOTTOM

		mov	ax,4					; take 4th para
		push	ax
		call	_PARNI
		add	sp,2
		mov	RIGHT,al				; assign to right

		push	cx					; preserve coordinate
		push	dx					; registers

		mov	ch,TOP				; assign TOP to high CX
		mov	cl,LEFT				; assign LEFT to low CX
		mov	dh,BOTTOM				; assign BOTTOM to high DX
		mov	dl,RIGHT				; assign RIGHT to low DX

		xor	ax,ax				; zero out AX
		push	ax
		mov	ax,0601h				; request roll up service
		mov	bh,07				; normal attribute
		int	10h					; issue video int

		pop	ax					; restore registers
		pop	dx					; before calling RETs
		pop	cx					;	|

		pop	es					;	|
		pop	ds					;	|
		pop	bp					;	|

		call	_RET					; Clipper return (actual cleaning)

		ret						; actual physical return
ROLLUP	endp						; end of process
;
;
ROLLDN	proc	far
		push	bp
		mov	bp,sp

		push	ds
		push	es

		mov	ax,1
		push	ax
		call	_PARNI
		add	sp,2
		mov	TOP,al

		mov	ax,2
		push	ax
		call	_PARNI
		add	sp,2
		mov	LEFT,al
	
		mov	ax,3
		push	ax
		call	_PARNI
		add	sp,2
		mov	BOTTOM,al
		mov	ax,4
		push	ax
		call	_PARNI
		add	sp,2
		mov	RIGHT,al

		push	cx
		push	dx

		mov	ch,TOP
		mov	cl,LEFT
		mov	dh,BOTTOM
		mov	dl,RIGHT

		xor	ax,ax
		push	ax
		mov	ax,0701h				; request roll down service
		mov	bh,07
		int	10h

		pop	ax
		pop	dx
		pop	cx

		pop	es
		pop	ds
		pop	bp

		call	_RET

		ret
ROLLDN	endp
;
_prog	ends
		end

