* Function: MREPLACE
* Author..: Richard Low
* Syntax..: MREPLACE()
* Returns.: True if successful.
* Notes...: Procedure to replace fields in database with M->memvars
*

FUNCTION MREPLACE
PARAMETERS p_first, p_last
PRIVATE f_alias, f_x, f_field

*-- if no fields in database or no file is open
IF FCOUNT() = 0
   *-- bomb out
   RETURN .F.
ENDIF

*-- see if they specified a starting field number, default to 1st field
p_first = IF( TYPE('p_first') = 'N', p_first, 1 )

*-- see if they specified an ending field number, default to last field
p_last = IF( TYPE('p_last') = 'N', p_last, FCOUNT() )

*-- get the alias name of the current database
f_alias = ALIAS()

*-- go thru all fields in database
FOR f_x = p_first TO p_last
   f_field = FIELD(f_x)

   IF TYPE('M->&f_field') = 'U'
      RETURN .F.
   ENDIF

   REPLACE &f_alias.->&f_field WITH M->&f_field
NEXT f_x

RETURN .T.
