/**********************************************************************/
/*     Function: RelIndex                                             */
/*     Writer: Kraig Krist/TBCS                                       */
/*     Date: March 28, 1994                                           */
/*     Description: Determine relative index number within an NTX     */
/*                  file. Based on NTX Dump example by Rick Spense.   */
/**********************************************************************/
/*                    ----- Modification Log -----                    */
/*     When:                                                          */
/*     Why:                                                           */
/**********************************************************************/
/*                  ----- Notations Used -----                        */
/*                                                                    */
/*     pc = Pointer Char                                              */
/*     nl = Numeric Long                                              */
/*      n = Numeric                                                   */
/*      s = Structure                                                 */
/*     ps = Pointer Structure                                         */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/*     ***** Function Specifications *****                            */
/*                                                                    */
/*       Passed in: Ntx File, Recno() from DBF                        */
/*                                                                    */
/*       Returns: Corresponding Relative Index Number                 */
/*                0 = Not found                                       */
/*               -1 = Parameter error                                 */
/*               -2 = Ntx File Open error                             */
/*               -3 = Ntx File Header error                           */
/*               -4 = Ntx File Read error                             */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/*     ***** Calling Example  *****                                   */
/*        nRelIndex = RelIndex("TEST.NTX",Recno())                    */
/**********************************************************************/
/*                                                                    */
/*     ***** Note  *****                                              */
/*     Remember to compile C program for use by Clipper with the      */
/* following line. Use the /Gh option if using C 6.x                  */
/*     CL /c /AL /FPa /Gs /Oalt /Zl relindex.c                        */
/**********************************************************************/
#define MAX_KEY 256
#define BUFFER_SIZE 1024
/**********************************************************************/
/*     Includes                                                       */
/**********************************************************************/
#include "extend.h" 
#include "string.h"
#include "fcntl.h"
#include "io.h"
/**********************************************************************/
/*     Define Structures                                              */
/**********************************************************************/
typedef struct
{
  unsigned sign;
  unsigned version;
  long root;
  long next_page;
  unsigned item_size;
  unsigned key_size;
  unsigned key_dec;
  unsigned max_item;
  unsigned half_page;
  char key_expr[MAX_KEY];
  Boolean unique;
} NTX_HEADER;
typedef struct
{
    long page;
    long rec_no;
    char key;
} ITEM;
typedef struct
{
    unsigned count;
    unsigned ref;
} BUFFER;
/**********************************************************************/
/*     Global variables                                               */
/**********************************************************************/
NTX_HEADER sNtxHeader;
int nNtxHandle;
static long nlRelIndexCtr;
static long nlRelIndex;
static long nlRecno;
/**********************************************************************/
/*     Function prototype                                             */
/**********************************************************************/
void WalkPage(long nlRoot);
/**********************************************************************/
/*     Function RelIndex                                              */
/**********************************************************************/
CLIPPER RelIndex()
{
  char *pcString;
  char *pcNtxFile;
  char *pcStopString;
  nlRelIndex = nlRelIndexCtr = nlRecno = 0L;
/**********************************************************************/
/*   Get parameters passed from calling Clipper Program.              */
/**********************************************************************/
  if (PCOUNT == 2 && ISCHAR(1) && ISNUM(2)) 
  {
    pcNtxFile = _parc(1);  
    pcNtxFile = strupr(pcNtxFile);
/**********************************************************************/
/*   Test for ".NTX". If not present concatenate it to the input      */
/* string.                                                            */
/**********************************************************************/
    pcString = strstr(pcNtxFile,".NTX");
    if (pcString == NULL)
    {
      strcat(pcNtxFile,".NTX");
    } /* endif */
/**********************************************************************/
/*   Open Ntx file.                                                   */
/**********************************************************************/
    nNtxHandle = open(pcNtxFile, _O_RAW | _O_RDONLY);
    if (nNtxHandle == -1)
    {
      nlRelIndex = -2;
    } /* endif */
/**********************************************************************/
/*   Read Ntx header.                                                 */
/**********************************************************************/
    if (nlRelIndex == 0)
    {
      if (read(nNtxHandle, (char *) &sNtxHeader, sizeof(NTX_HEADER))
               != sizeof(NTX_HEADER))
      {
        nlRelIndex = -3;
      } /* endif */
    } /* endif */
/**********************************************************************/
/*   Walk Ntx from root.                                              */
/**********************************************************************/
    nlRecno = _parnl(2);
    if (nlRelIndex == 0)
    {
      WalkPage(sNtxHeader.root);
    } /* endif */
  } /* endif */
  else
/**********************************************************************/
/*   Invalid parameters passed in from calling Clipper program.       */
/**********************************************************************/
  {
    nlRelIndex = -1;
  } /* endif */
/**********************************************************************/
/*   Return outcome to Clipper program.                               */
/**********************************************************************/
  _retnl(nlRelIndex);
} /* end of RelIndex */
/**********************************************************************/
/*     Walk Ntx tree looking for RECNO match.                         */
/**********************************************************************/
void WalkPage(long nlPageOffset)
{
  char *psPage;
  ITEM *psItem;
  BUFFER *psBuffer;
  unsigned nI;
  unsigned *pnItemRef;
  if (nlRelIndex == 0L)
  {
/**********************************************************************/
/*     Use _xalloc (instead of malloc) to allocate page dynamically to*/
/* avoid using stack space.                                           */
/**********************************************************************/
    psPage = _xalloc(BUFFER_SIZE);
/**********************************************************************/
/*     Move to this position in the Ntx file.                         */
/**********************************************************************/
    lseek(nNtxHandle,nlPageOffset,0);
/**********************************************************************/
/*     Read current Ntx page.                                         */
/**********************************************************************/
    if (read(nNtxHandle, psPage, BUFFER_SIZE) != BUFFER_SIZE)
    {
      nlRelIndex = -4;
    } /* endif */
/**********************************************************************/
/*     Properly typecast pointers.                                    */
/**********************************************************************/
    psBuffer = (BUFFER *) psPage;
    pnItemRef = &psBuffer->ref;
/**********************************************************************/
/*     Process Ntx index pages looking for RECNO match.               */
/**********************************************************************/
    for (nI=0; nI < psBuffer->count; nI++)
    {
      psItem = (ITEM *) &psPage[pnItemRef[nI]];
      if (psItem->page)
/**********************************************************************/
/*     If Index page indicator, recursively call WalkPage.            */
/**********************************************************************/
      {
        WalkPage(psItem->page);
      } /* endif */
/**********************************************************************/
/*     Increment Relative Index Counter.                              */
/**********************************************************************/
      nlRelIndexCtr++;
/**********************************************************************/
/*     Check for RECNO match.                                         */
/**********************************************************************/
      if (psItem->rec_no == nlRecno)
/**********************************************************************/
/*     RECNO matched! The Relative Index Counter is the Relative Index*/
/**********************************************************************/
      {
        nlRelIndex = nlRelIndexCtr;
      } /* endif */
    } /* end for */
/**********************************************************************/
/*     Handle extra right pointer.                                    */
/**********************************************************************/
    psItem = (ITEM *) &psPage[pnItemRef[psBuffer->count]];
    if (psItem->page)
/**********************************************************************/
/*     If Index page indicator, recursively call WalkPage.            */
/**********************************************************************/
    {
      WalkPage(psItem->page);
    } /* endif */
/**********************************************************************/
/*     Since _xalloc() was used to allocate memory we must use        */
/* _xfree() to free (release) the memory.                             */
/**********************************************************************/
    _xfree(psPage);
  } /* endif */
} /* end of WalkPage */
