*******************
* ReadTXT.prg
*
* Substitute for Buerg's List program with Clipper.  Allows user
*    to examine any text type file, such as generated report files
*    (or source code files, if you have set up your error handler
*     to call this program with the name of the error program),
*    without having to use the RUN or ! command with its very high
*    RAM overhead requirements.  The program attempts to locate
*    an unused file area and verify that 2 free file handles are
*    available before it begins.  (File handles available are the number
*    of file handles you made available in you CONFIG.SYS file, minus 3,
*    minus the number of DBFs and Index files open currently open.
*    The program works by loading a DBF file with the text file to
*    be examined.  It then uses the SCROLL function to move the
*    current picture of text on the screen.
*
* Requires Clipper Summer '87 version and the Extend library supplied
*   with the Summer '87 Clipper.  (Include the EXTEND.LIB with CLIPPER.LIB
*   when you link)
*
* Originally written by Eric Engelmann for the US Army.
*   Donated to public domain. 3-31-88
*
* This program has seen only minimal testing.  Any comments, bugs,
*  suggestions, etc. should be directed to:
*  EMS   Att: Eric Engelmann
*  11701 Karen Drive
*  Potomac, MD 20854
*   Tel: (301) 299-9239
*
********************
parameters textfile
set scoreboard off
private lastrec,row,boxtop,boxbott,toprec,offset,m,newrec,oldtop,;
        phrase,n,freearea,handle1,handle2,pseudonym

clear

* Store the number of the current work area so we can return when done.
pseudonym=ltrim(rtrim(str(select())))

* Select the area to open the DBF in.
if freehndls()
   select 0
else
   @ 5,5 say "There are not enough file handles available."
   wait
   return
endif

@ 5,5 say 'Wait while file &textfile is prepared for display...'

use text
zap
append from &textfile SDF

* Present the database in a window.
clear

* Paint titles.
set color to n/w
@ 0,0 say space(80)
@ 0,0 say 'File &textfile'
@ 0,72 say dtoc(date())
set color to w/n

lastrec=reccount()

go top


row=1             &&Screen row.
boxtop=1          &&Top row of display box.
toprec=1          &&Record number on diplay at top line of box.
boxbott=23        &&Bottom row of display box.
offset=1          &&Starting position to display for each line of text.

* Paint first screen.
showlins()

set color to n/w
@ 24,0 clear
@ 24,0 say '<'+chr(24)+chr(25)+chr(26)+chr(27)+'/PgDn/PgUp/Home/End> - '+;
           'Cursor Moves  F-Find  <F1>-Help  X-Exit'
set color to w/b

offset=1
do while .t.
   set color to n/w
   @ 0,19 say 'Line: '+str(toprec,6,0)
   set color to w/b
   
   m=inkey(0)
   
   
   do case
      * User wants to pan right.
   case m=4
      if offset<81
         offset=offset+20
      endif
      go toprec
      showlins()
      
      * User wants to pan left.
   case m=19
      if offset>=21
         offset=offset-20
      endif
      go toprec
      showlins()
      
      * User wants top of file.
   case m=1
      go 1
      toprec=1
      showlins()
      
      * User wants end of file.
   case m=6
      if lastrec>=boxbott-boxtop
         go lastrec-(boxbott-boxtop)
      else
         go 1
      endif
      toprec=recno()
      showlins()
      
      * User wants to page down a screen.
   case m=3
      if toprec+boxbott-boxtop<=lastrec
         toprec=toprec+boxbott-boxtop
      else
         toprec=lastrec
      endif
      go toprec
      showlins()
      
      * User wants to page up a screen.
   case m=18
      newrec=toprec-(boxbott-boxtop)
      if newrec>0
         toprec=newrec
      else
         toprec=1
      endif
      go toprec
      showlins()
      
      * User chose uparrow.
   case m=5
      if toprec>1
         scroll(boxtop,0,boxbott,79,-1)
         * Got to the new record.
         toprec=toprec-1
         go toprec
         @ boxtop,0 say subs(line,offset,79)
      else
         * If we are at the first record already, do nothing.
      endif
      
      * User chose down arrow.
   case m=24
      if toprec-boxtop+boxbott<lastrec
         scroll(boxtop,0,boxbott,79,1)
         toprec=toprec+1
         go toprec+boxbott-boxtop
         @ boxbott,0 say subs(line,offset,79)
      endif
      
      * User claims he needs help.
   case m=28 .or. m=72 .or. m=104 .or. m=63
      save screen
      set color to n/w
      @ 24,0 clear
      @ 24,0 say 'You gotta be kidding.  What do you need help for?'
      m=inkey(0)
      set color to w/n
      restore screen
      
      * User wants to locate a word.
   case m=70 .or. m=102
      oldtop=toprec
      go toprec
      set color to n/w
      @ 24,0 clear
      phrase=space(15)
      @ 24,0 say 'Search for? ' get phrase
      read
      phrase=trim(phrase)
      locate next 1000000 for phrase$line
      if eof()
         @ 24,0 clear
         @ 24,0 say '&phrase not found.'
         m=inkey(0)
         toprec=oldtop
         go toprec
      else
         toprec=recno()
      endif
      
      set color to w/b,n/w
      showlins()
      set color to n/w
      @ 24,0 clear
      @ 24,0 say '<'+chr(24)+chr(25)+chr(26)+chr(27)+'/PgDn/PgUp/Home/End>'+;
                ' - Cursor Moves  F-Find  <F1>-Help  X-Exit'
      set color to w/b
      
      * User pressed X or ESC, wants to exit.
   case m=88 .or. m=120 .or. m=27
      use
      clear
      * Select the area in use before R.prg was run before returning.
      select &pseudonym.
      return
      
   endcase
   
enddo

************************
function showlins
@ boxtop,0 clear to boxbott,79
row=boxtop
do while .not. eof() .and. row<=boxbott
   @ row,0 say subs(line,offset,79)
   skip
   row=row+1
enddo
lastrow=row-1
return .t.
*************************

*************************
function freehndls
* Returns .t. if two free file handles (one for text.dbf and one
*  for the text file to be loaded) are available, otherwise returns
*  .f.

if file("$$$.$$1")
   delete file $$$.$$1
endif
if file("$$$.$$2")
   delete file $$$.$$2
endif

handle1=fcreate("$$$.$$1")
if ferror()<>0
   * We couldn't create a file, or there are no free handles.
   return .f.
else
   handle2=fcreate("$$$.$$2")
   if ferror()<>0
      fclose(handle1)
      delete file $$$.$$1
      return .f.
   endif
   fclose(handle1)
   fclose(handle2)
   delete file $$$.$$1
   delete file $$$.$$2
   return .t.
endif

**********************************
*  End of ReadTXT.prg
*
