#include "inkey.ch"

function _colors( lColorsChanged )
   local oScrnColors
   local oBox, oStatus := QStatus():new()
   oBox := QMsgBox( "QSysColors()", ;
        "How  many  times have  you had  to fiddle  around with;"+ ;
        "color settings in your application to get a consistent;" + ;
        "user interface?  With the QSysColors() class  function;" + ;
        "you can  set the  colors from a  default configuration;"+ ;
        "file - automatically sensitive  to whether or  not the;" + ;
        "user has a  color monitor.  Alternatively  you can let;" + ;
        "your users pick all their own colors  and save them in;" + ;
        "their  own configuration  file.  If you don't want the;" + ;
        "user to play  around with the color settings, then you;" + ;
        "can pick  the colors  yourself, and  use those for the;" + ;
        "application.                                          ;;" + ;
        "This function sets a number of variables which are all;" + ;
        "automatically used by the other interface functions.  ;" + ;
        "you can make use of these color settings yourself and ;" + ;
        "integrate them into your own functions.               ;" + ;
        "Hit any key to continue....", 2 )
    inkey(0)
    oBox:off()
    oBox := QMsgBox( "QSysColors()", ;
        "Most functions  like this require  that the user  know;" + ;
        "what  the  different  screen elements are called.     ;" + ;
        "QSysColors() makes it simple for an inexperienced user;" + ;
        "to change the colors of the different screen elements.;;" + ;
        "Hit any key to demonstrate this feature....", ;
        2 )
   inkey(0)
   oBox:off()
   setBlink(.F.)
   oScrnColors := qSysColors():new()
   if qIsColor()
      oScrnColors:setDefFile( "XCOLORS.CFG" ) //Set config file
   else
      oScrnColors:setDefFile( "XMONO.CFG" ) //Set config file
   endif
   oScrnColors:setColors()      //Get color defaults from config file
   oScrnColors:activate()       //Interactive color settings (saves to config
                                //file if it has been set)
   lColorsChanged := .T.
   oBox := QMsgBox( "New Colors", ;
        "The colors that you changed will now be reflected;"+ ;
        "in this demonstration.  However the next time you run;" + ;
        "the demo, the original colors will be restored.;;" + ;
        "Hit any key to continue....", ;
        2 )
   inkey(0)
   oBox:off()
   keyBoard( chr( K_ESC ) + chr( K_ESC ) + chr( K_ESC ))
return Nil

