#include "qboxes.ch"
#include "inkey.ch"
#include "qlib.ch"
#include "qindex.ch"
memVar SCBrowData

static acTagged := {}

function _browse()
   local oScrnColors, nSelected, oStatus, oldTopic
   oStatus := QStatus():new()
   use CUSTOMER shared new
   if ! file( "custComp.ntx")
      index on upper( company ) to custcomp
   endif
   set index to custComp
   qAlert( "qBrowse() function", ;
       "The qBrowse() function is provides you with maximum;" + ;
       "flexibility.  The following browse screens all use;" + ;
       "qBrowse(). Note that you can press any letter of the;" + ;
       "alphabet to perform an indexed search based on the;" + ;
       "letters that have been pressed. This is an automatic;" + ;
       "feature of qBrowse() that is active because there is;" + ;
       "an active index open.  This feature can be disabled." ;
       , ;
       {"Hit  to continue"}, ;
       2)
   if lastkey() == K_ESC
      return nil
   endif

   oStatus:push( "You are browsing through the customers. Hit <F1> to find out about help!")
   oldTopic := QHelpTopic( "First Browse" )
   setKey( K_F1, {||QHelp( NIL, NIL, SOLID )} )
   nSelected := qbrowse( 6, NIL, 20, NIL, NIL, "<F1>Help <>Select")
   setKey( K_F1, NIL )
   QHelpTopic( oldTopic )
   keyStatus( NIL, nSelected )
   oStatus:pop()

   oStatus:push( "Alternate color indicates balance > 0")
   nSelected := qbrowse( 5, 10, 19, 69, ;
        NIL, NIL, ;
        NIL, NIL, ;
        NIL, ;
        NIL, {|x,y|balKeyHandler(x,y, 19, 48)}, ;
        {|x,y|balKeyHandler(0,y, 19, 48)}, ;
        NIL, ;
        NIL, NIL, "",;
        {|x|CUSTOMER->balance>0}, ;
        { "R+/N*", "B/W*" }, ;
        1 )
   keyStatus( NIL, nSelected )
   oStatus:pop()
   oStatus:push( "You can also use the qBrowse() function as a pick list")

   qAlert( "qBrowse() pick list", ;
       "By defining your own keys in your customized key;" + ;
       "handler, you can build extra functionality into;" + ;
       "browse screens. The following browse screen uses;" + ;
       "a key handler that re-maps the <+> key to the down;" + ;
       "arrow key after tagging the current record. The <->;" + ;
       "key untags all the selected records but is not;" + ;
       "re-mapped to another key." ;
       , ;
       {"Hit  to continue"}, ;
       2)

   oStatus:push( "The search feature lets you find a record by typing in letters")
   nSelected := qbrowse(7, 25, 19, 25+len(CUSTOMER->company)+2, ;
        'Tag Customers', "<+>Toggle <->Untag all", ;
        {'tagged()','Cust_ID'}, {'', 'Customer'}, ;
        NIL, ;
        NIL, { |x,y| keyHandler(x,y) }, ;
        NIL, ;
        2 )
   dispBegin()
   oStatus:pop()
   oStatus:pop()
   dispEnd()

   qAlert( "qBrowse() pick list", ;
       "With a little creative key handling you can even ;" + ;
       "browse two databases simultaneously side by side.";
       , ;
       {"Hit  to continue"}, ;
       2)
   oStatus:push( "You are browsing through both employees and customers.")
   oldTopic := QHelpTopic( "First Browse" )
   setKey( K_F1, {||QHelp( NIL, NIL, SOLID )} )
   multibrowse()
   setKey( K_F1, NIL )
   QHelpTopic( oldTopic )
   oStatus:pop()
return Nil

function keyHandler( nLastKey, oBrowse )
local nPos
do case
   case nLastKey == K_PLUS
        iif( ( nPos := aScan( acTagged, CUSTOMER->cust_id ) ) == 0, ;
             aAdd( acTagged, CUSTOMER->cust_id ),/* Would be more useful to add the record # to the acTagged
        array instead of customer name so that we can tell exactly
        which records were tagged in the case where we have customers
        with the same name. */eval( {||aDel( acTagged, nPos ), ;
        aSize( acTagged, len( acTagged )-1 ) } ) )
        oBrowse:refreshCurrent()
        do while ! oBrowse:stabilize()
        endDo
        return K_DOWN

   case nLastKey == K_MINUS
        acTagged := {}
        oBrowse:refreshAll()
        do while ! oBrowse:stabilize()
        endDo return .T.

   case nLastKey == K_ENTER
        keyStatus( "You tagged these records...;"+ ;
                   qAtoS( ";", acTagged, .T. ) )
        return .F. //If .T. then qBrowse() would ignore the key &
                   //we want to EXIT the browse endCase return .F.
endCase
return .F.

function balKeyHandler( nLastKey, oBrowse, nRow, nCol )
local oBox
   if nLastKey == 0
      @ nRow-1, nCol say "Balance: "+str( CUSTOMER->balance, 7, 2 ) color SCBrowData
      oBox := QMsgBox( "", "Notice the balance;" + ;
                           "indicated in the footer;;" + ;
                           "Hit any key to continue....", 3 )
      inkey(0)
   else
      @ nRow-1, nCol+9 say str( CUSTOMER->balance, 7, 2 ) color SCBrowData
   endif
return .F.

function tagged()
return iif( aScan( acTagged, CUSTOMER->cust_id )==0, " ", "" )

static function keyStatus( cMsg, nSelected )
   if valType( cMsg ) <> "C"
      cMsg := iif( nSelected == 0, ;
              "You pressed ESC", ;
              "You selected record "+ lTrim(str( nSelected )) )
   endif
   qAlert( "Status", cMsg )
return Nil
