******************************************************************************
*PROPCI.PRG - a program that calculates confidence intervals for a proportion*
*Kevin Sullivan, Centers for Disease Control, 1600 Clifton Rd NE, MS A08     *
* Atlanta, GA  30333                                                         *
*Version 1.2, 1/9/89                                                         *
******************************************************************************
SET COLOR TO W/B
CLEAR
SET CONFIRM ON
SET PROCEDURE TO propci
PUBLIC D,N,K,DLCOMB
set scoreboard off
set bell off
set echo off
set talk off
set status off
CLEAR GETS
@ 1,2 SAY DATE()
SET COLOR TO W+/b
@ 1,30 SAY '**  PROPCI 1.2  **'
@ 0,0 TO 2,79 DOUBLE
SET COLOR TO G+/B
@ 4,14 SAY 'Numerator:            / Denominator: '
LOOP2=.T.
DO WHILE LOOP2
  SET COLOR TO W/B
  @ 16,0 clear
  n='         '
  d='         '
  @ 4,25 GET n picture '########'
  @ 4,51 GET d picture '########'
  READ
  IF val(d) < val(n)
    SET COLOR TO W+/B
    @ 15,14 SAY 'The denominator cannot be less than the numerator'
    SET COLOR TO W/B
    LOOP
  ENDIF
  IF VAL(d)=0
    SET COLOR TO W+/B
    @ 15,14 SAY 'The denominator cannot be equal to zero          '
    SET COLOR TO W/B
    LOOP
  ENDIF
  ci='95'
  @ 6,14 say 'Enter two-sided confidence level (90, 95, or 99%): ' get ci picture '##'
  read
  do case
    case ci='90'        && 90% two-sided confidence interval
      zval=1.645
      tailprob=.05
    case ci='99'        && 99% two-sided confidence interval
      zval=2.5758
      tailprob=.005
    otherwise           && By default will calculate 95% ci
      ci='95'
      zval=1.96
      tailprob=.025
  endcase
  n=val(n)
  d=val(d)
  pp=n/d
  q=1-pp
  sd=SQRT((pp*q)/d)
  lci=pp-(zval*sd)
  uci=pp+(zval*sd)
  lcic=pp-(zval*sd)-(1/(2*d))
  ucic=pp+(zval*sd)+(1/(2*d))
  @ 8,14 SAY 'The point estimate is: ' + STR(pp*100,7,3) + '%'
  set color to R+/B
  @ 10,5 SAY 'Confidence Interval Method                 Std Error       ' + ci + '% CI'
  set color to GR+/B
  @ 11,5 SAY 'Normal Approx. to the Binomial              ' + str(sd*100,7,3) + '   ' + STR(lci*100,7,3) + ', ' + STR(uci*100,7,3)
  @ 12,5 SAY 'Normal Approx. with Correction Factor       ' + str(sd*100,7,3) + '   ' + STR(lcic*100,7,3) + ', ' + STR(ucic*100,7,3)
  if pp <> 0
    pl=(((2*d*pp)+(zval**2)-1)-(zval*sqrt((zval**2)-(2+(1/d))+(4*pp*(d*q+1)))))/(2*(d+(zval**2)))
    wl=(d/(d+zval**2))*((n/d)+((zval**2)/(2*d))-zval*sqrt((n*(d-n)/d^3)+(zval^2/(4*d^2))))
  else
    pl = 0
    wl = 0
  endif
  if pp <> 1
    pu=(((2*d*pp)+(zval**2)+1)+(zval*sqrt((zval**2)+(2-(1/d))+(4*pp*(d*q-1)))))/(2*(d+(zval**2)))
    wu=(d/(d+zval**2))*((n/d)+((zval**2)/(2*d))+zval*sqrt((n*(d-n)/d^3)+(zval^2/(4*d^2))))
  else
    pu = 1
    wu = 1
  endif
  @ 13,5 say 'Wilson Method                                         ' + str(wl*100,7,3) + ', ' + str(wu*100,7,3)
  @ 14,5 say 'Quadratic Method                                      ' + str(pl*100,7,3) + ', ' + str(pu*100,7,3)
  @ 15,10 say space(60)
  IF (d*pp*q) < 5
    SET COLOR TO W+/B
    @ 17,1 say space(78)
    @ 18,9 SAY '**The normal approximation may not be valid for this example**'
    SET COLOR TO W/B
  endif
*
*exact limits
*
  ans='N'
  @ 19,19 SAY 'Would you like exact limits? (Y/N) '
  @ 19,55 GET ANS PICTURE '!'
  READ
  IF ANS='Y'
    set color to W+*/B
    @ 23,33 say 'Calculating ...'
    set color to W/B
    fishlow=0
    fishup=0
    midplow=0
    midpup=0
    ci_num=val(ci)
    do exact with n,d,ci_num,fishlow,fishup,midplow,midpup
    set color to GR+/B
    @ 15,5 say 'Exact Binomial                                        ' + str(fishlow*100,7,3) + ','
    @ 15,68 SAY str(fishup*100,7,3)
    @ 16,5 say 'Miettinen Limits (Mid-p)                              ' + str(midplow*100,7,3) + ','
    @ 16,68 SAY str(midpup*100,7,3)
  ENDIF
  @ 23,33 say space(25)
  ANS='Y'
  @ 19,19 SAY 'Would you like to do another? (Y/N)                 '
  @ 19,55 GET ANS PICTURE '!'
  READ
  IF ANS='Y'
    @ 8,38 SAY SPACE(20)
    @ 11,48 SAY SPACE(35)
    @ 12,48 SAY SPACE(35)
    @ 13,48 SAY SPACE(35)
    @ 14,48 say space(35)
    @ 15,0 say space(79)
    LOOP2=.T.
  ELSE
    LOOP2=.F.
  ENDIF
ENDDO
clear
return
******************************************************************************
*exact procedure for proportions                                             *
*This program is based on a BASIC program written by Ray Simons              *
*which was based on the Rothman and Boice text "Epidemiologic Analysis       *
*With a Programmable Calculator".  Performs F-test method for calculating    *
*Fishers and mid-p confidence intervals.                                     *
*Translated into dBase and modified by Kevin Sullivan                        *
*12/22/89                                                                    *
******************************************************************************
procedure exact
parameter a,m1,p3,fishlow,fishup,midplow,midpup
flag0=1    && 1 is for fishers exact, 2 is for mid-p
flag1=1    && 1 is for upper tail, 2 is for lower tail
flag2=1    && 1 is if a<>m1, 2 is if a=m1
flag3=1    && 1 is to stay in subroutine, 2 is to exit
flag4=1    && 1 if p>=.5, 2 if p<.5
flag5=1    && i if p<>.5, 2 if p=.5
b=m1-a
s1=a/m1
if s1=.5
  flag5=2
endif
if s1<.5  && if p<.5, swap exposure categories to speed things up
  aa=a    && and take care of a=0
  a=b
  b=aa
  s1=a/m1
  flag4=2
endif
if a=m1
  flag2=2
endif
m1_a=m1-a
dlm1=0
dla=0
dlm1_a=0
do fdlgama with m1,dlm1
do fdlgama with a,dla
do fdlgama with m1_a,dlm1_a
fishlow=0
fishup=0
midplow=0
midpup=0
do case
  case flag4=2
    if flag2=2
      fishlow=1
    else
      do main with fishlow
    endif
    fishlow=1-fishlow
    flag1=2     &&lower bound
    do main with fishup
    fishup=1-fishup
    flag0=2
    flag1=1
    if flag2=2
      midplow=1
    else
      do main with midplow
    endif
    midplow=1-midplow
    flag1=2
    do main with midpup
    midpup=1-midpup
  case flag4=1 .and. flag5=1
    if flag2=2
      fishup=1
    else
      do main with fishup  &&fisher exact upper
    endif
    flag1=2
    do main with fishlow
    flag0=2
    flag1=1
    if flag2=2
      midpup=1
    else
      do main with midpup
    endif
    flag1=2
    do main with midplow
  case flag5=2
    do main with fishup  &&fisher exact upper
    fishlow=1-fishup
    flag0=2
    do main with midpup
    midplow=1-midpup
endcase
return
***************
procedure main
parameter z
d3=0
r0=(p3/100-1)/2
p=sqrt(s1*(1-s1)/m1)
keepgo=.t.
do while keepgo
  if p=0
    p=p+1/a-.017455065
  endif
  if flag1=1
    p=-p
  endif
  r8=s1-p
  r9=r8
  do sub
  r6=d3
  r8=r8-.017455065
  keepgo2=.t.
  do while keepgo2
    do sub
    e1=d3
    d1=r8
    d2=e1
    d3=d2*((r9-r8)/(r6-e1))
    r8=r8-d3
    r9=d1
    r6=d2
    if abs(d3/r8)>.000000001
      loop
    endif
    exit
  enddo
  exit
enddo
z=r8
return
**************
procedure sub
if flag1=1
  r2=(a+1)*2
  r1=b*2
else
  r2=a*2
  r1=(b+1)*2
endif
r3=r8
r7=2
r4=r8^(r2/2)
i=(r1-2)/2
if i=0
  d1=r4
  do sub2
  return
endif
r3=1-r3
a1=r2/2*r3
r5=a1+1
i=i-1
do while .t.
  if i<=0
    exit
  else
    r2=r2+2
    r7=r7+2
    a1=a1*(r2*r3/r7)
    r5=r5+a1
    i=i-1
    loop
  endif
enddo
d1=r5*r4
do sub2
return
***************
procedure sub2
if flag1=1
  d2=1-d1
else
  d2=d1
endif
if flag0=1
else
  p0=EXP(dlm1-(dla+dlm1_a))/2*r8^a*(1-r8)^b
  d2=d2-p0
  d3=r0+d2
endif
d3=r0+d2
return
******************************************************************************
* Procedure fdlgama                                                          *
* Logarithm of gamma function by Pike MC and HILL ID, CACM algo. 291         *
* This code was translated into FORTRAN by Gerard E. Dallal and then into    *
* dBase by Kevin Sullivan.                                                   *
******************************************************************************
PROCEDURE FDLGAMA
PARAMETER S,DLGAMA
PRIVATE ALL
X=S + 1
DLGAMA = 0
IF X <= 0
  RETURN
ENDIF
F= 0
IF X < 7
  F = 1
  Z = X - 1
  AGAIN=.T.
  DO WHILE AGAIN
    Z= Z + 1
    IF Z < 7
      X = Z
      F = F * Z
    ELSE
      AGAIN=.F.
    ENDIF
  ENDDO
  X = X + 1
  F = -LOG(F)
ENDIF
Z=1/(X**2)
DLGAMA = F + (X - 0.5) * LOG(X) - X + 0.918938533204673 + (((-0.000595238095238 ;
* Z + 0.000793650793651) * Z - 0.002777777777778) * Z + 0.083333333333333) / X
RETURN
