/*  The file is primarily based upon POPUPCAL.PRG (see below). 
 *  The following modifications and additions have been added:
 *
 *  1.  A prompt automatically pops up on the bottom line of the screen
 *      when the user enters a date field.
 *
 *  2.  User may use numeric +/- (ala Quicken) to change dates.
 *
 *  3.  Changed the keys used to move about in the popup calendar
 *      and made minor modifications to the results produced by some
 *      some keys.
 *
 *  The following syntax is used to call this routine:
 *
 *   @ x, y get <date variable> picture "@D";
 *            when dStart(x, y);
 *            valid dStop()
 *
 *  The original documentation for POPUPCAL is intact below.  See the case
 *  statement in the main body of the program for the revised key stroke
 *  results.
 *
 *  These modifications were written for my own use and were not
 *  intended to be uploaded to CI$.  These limited comments and the
 *  upload is in response to a fellow CI$er looking for a pop up
 *  calendar.
 *
 *  Jerry Rhoads
 *  7/30/94
 */
 


/*
 * File......: POPUPCAL.PRG
 * Author....: Jeff Mason [CIS: 70541,1455]
 * Date......: $Date$
 * Revision..: $Revision$
 * Log File..: $Logfile$
 *
 * This work is an enhancement and extension of CAL50.PRG, written
 * by Paul H. Earley.  It is placed in the public domain with his
 * concurrence.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     FT_POPUPCAL
 *  $CATEGORY$
 *     Date/Time
 *  $ONELINER$
 *     Pop up calendar that returns user-selected date.
 *  $SYNTAX$
 *     FT_POPUPCAL( [<dInitDate>] [, <nTopRow>] [, <nLeftCol>]
 *		    [, <lShadow>] [, <aColor>] )
 *		 -> dSelDate
 *
 *  $ARGUMENTS$
 *
 *     <dInitDate>   selects month and year of initial calendar
 *		     display.  Date will be highlighted.  Default
 *		     is system date.
 *
 *     <nTopRow>     top row on screen where calendar appears.
 *
 *     <nLeftCol>    left-most column where calendar appears.
 *
 *		     The default location will place the calendar in
 *		     the opposite quadrant from the cursor's current
 *		     location.
 *
 *     <lShadow>     is a logical variable.  If true (.t.), it uses
 *		     FT_SHADOW() to add a transparent shadow to the
 *		     display; default (.f.)
 *
 *     <aColors>     a color array for display.  Default colors are
 *		     provided; a test for monochrome is performed
 *		     if no colors are passed.
 *
 *     All arguments are optional, but to skip an argument, a dummy
 *     argument must be passed.  See EXAMPLES.
 *
 *  $RETURNS$
 *
 *     <dSelDate>    date of selected calendar date in date format.
 *
 *  $DESCRIPTION$
 *
 *     Displays a pop up calendar with the current date
 *     highlighted (default).  The user selects the desired date
 *     through cursor positioning via the keyboard.  The selected
 *     (highlighted) date is returned.	The calendar can be called
 *     two ways:
 *
 *     1. By a direct call to POPUPCAL which will pop-up a
 *	  calendar with the passed date highlighted. It will
 *	  appear starting at the row: nTopRow, and the
 *	  column: nLeftCol
 *
 *     2. By a SET KEY TO POPUPPROC. This will pop-up a calendar
 *	  but not allow the user to use the returned value. You
 *	  may wish to modify this procedure to stuff the keyboard
 *	  if you chose.
 *
 *     WARNING:  FT_POPUPCAL uses FT_SAVRGN, FT_RSTRGN, and
 *		 FT_SHADOW from the NANFORUM Toolkit!
 *
 *  $EXAMPLES$
 *
 *     Calling Method 1:
 *     dSelDate := FT_POPUPCAL( )
 *     dSelDate := FT_POPUPCAL( , 10, 20, .t., ;
 *		 { 'GR+/B', 'W+/B', 'W/B', 'W+/N+', 'W+/BG+', 'W+/N+', ;
 *		   'W/N+', 'W/B' } )
 *
 *     Calling Method 2:
 *     SET KEY <user_defined> TO POPUPPROC
 *	  .
 *	  .
 *     PROCEDURE POPUPPROC
 *	FT_POPUPCAL( )
 *     RETURN
 *
 *  $SEEALSO$
 *  $INCLUDE$
 *     inkey.ch
 *  $END$
 */

/*
This work is an enhancement and extension of CAL50.PRG, written
by Paul H. Earley.  It is placed in the public domain with his
concurrence.

General calendar information:

   1. The active keys are as follows:

       Up-arrow: Move to one week previously. If in a different month,
		 move accordingly.

     Down-arrow: Move to one week later. If in a different month, move
		 accordingly.

     Left-arrow: Move one day earlier. If in a different month, move
		 accordingly.

    Right-arrow: Move one day later. If in a different month, move
		 accordingly.

	Page-Up: Move to previous month. If year changes, do that too.

      Page-Down: Move to next month. If year changes, do that too.

	    -  : Move to previous year.

	    +  : Move to next year.

	   Home: Move calendar to current day, month, and year.

	 Escape: Remove calendar and return to the calling program the
		 date that the calendar was called with.

     Return Key: Remove calendar and return the highlighted date.

   2. The system date must be set so Clipper can access it using DATE()

   3. If you are on the last day of a month with 31 days, moving to the
      next month will leave the selected date at day 31 or if the month
      has less than 31 days, the calendar will highlight the last day
      of that month.

   4. Most of the color elements of the calendar can be specified
      separately by modifying the code.  Color is default.  If no
      colors are specified, the code checks for monochrome through
      the Clipper ISCOLOR() function.

*/

#ifdef FT_TEST

   /*
    *  This demo shows the two ways of calling POPUPCAL referred to
    *  above.
    */

   FUNCTION MAIN()

   LOCAL nDate:=DATE()
   SET SCOREBOARD OFF
   SET DATE AMERICAN
   SET ESCAPE ON

   SETCANCEL(.F.)

   Clear Screen
   SETCOLOR( "W+/BG+")
   DISPBOX(0,0,MAXROW(),MAXCOL(),REPLICATE(CHR(176),9))
   MakeBox(1,20,3, 59)
   @ 2, 22 SAY "POP UP CALENDAR DEMONSTRATION PROGRAM"
   MakeBox(6, 15, 22, 65)
   @ 8, 17 SAY "This demonstrates a hotkey call to the Pop Up"
   @ 10, 19 SAY "Calendar.  Press any key to continue...."
   INKEY(0)
   nDate2 := FT_PopUpCal()
   @ 12,25 SAY "The returned date is: "+DTOC(nDate2)
   @ 16, 20  SAY "Now do calendar with an optional shadow."
   @ 18,29 SAY "Any key to continue..."
   INKEY(0)
   nDate2 := FT_POPUPCAL(,2,10,.t.)
   @ 20,29 SAY "Any key to quit demo."
   INKEY(0)
   SETCOLOR("W/N")
   Clear Screen
   DevPos(23,0)
   ? "All done."
   QUIT
   RETURN


   FUNCTION MakeBox(t,l,b,r)

      SETCOLOR("W+/B")
      @ t,l CLEAR TO b,r
      FT_SHADOW(t,l,b,r)

   RETURN NIL

#endif

**************************************************************

#include "inkey.ch"
#include "box.ch"

#define K_MINUS    45
#define K_EQUAL    61
#define K_PLUS	   43
#define K_SH_PGUP  57
#define K_SH_PGDN  51
#define K_C        99
#define K_c        67
#define K_CTRL_UP 397    && JR
#define K_CTRL_DN 401    && JR
#define pDate	   "D"
#define pOldDate   "D"
#define pNumeric   "N"
#define pLogical   "L"
#define pArray	   "A"
#define pLine1a    "   " + CHR( 26 ) + " "
#define pLine1b    "Day"
#define pLine2a    "CTRL   "
#define pLine2b    "Month"
#define pLine3a    "  +   -"
#define pLine3b    "Year"
#define pLine4a    "  Home"
#define pLine4b    "Init Date"
#define pLine5a    "CTRL Home"
#define pLine5b    "Today"
#define pLine6a    "   "
#define pLine6b    "Select Day"
#define pCalWidth  24  // Overall width of calendar, excluding shadow
#define pCalHeight 17  // Overall height of calendar, excluding shadow
#define pSBar	   "Ŀ"
#define pBold	   ""

// Set up manifest constants to access the window colors array
#define pC_Border  1   // Color of calendar border
#define pC_Title   2   // Color of month title
#define pC_DOW	   3   // Color of days of week header
#define pC_AnyDate 4   // Color of any unselected date
#define pC_SelDate 5   // Color of selected date
#define pC_InfoBox 6   // Color of info box
#define pC_PageBox 7   // Color of calendar page box
#define pC_Info    8   // Color of info text

static save_cVar
static cScreen
static cScreenm
static keylast
static d_mess          && JR

FUNCTION FT_POPUPCAL(dInitDate,nTopRow,nLeftCol,lShadow,aColors,dOldDate)

#translate VALIDATE(<x>, <y>, <z>)  =>	;
	   IF( <x> = NIL, <z>, IF( VALTYPE(<x>) != <y>, <z>, <x> ))

LOCAL lExit	   := .f.
LOCAL lNewMonth    := .f.
LOCAL cOldColor    := SETCOLOR()
LOCAL bChkMonth    := ;
	  {|D,nD|MONTH(D)==MONTH(D+nD) .AND. YEAR(D)==YEAR(D+nD)}
LOCAL nOldCursor, nLastKey, dWorkDate, nLastDOM, cMonth, nFirstDOW
LOCAL nDay, nMonth, nYear, cYear, nScrn_loc, nDayNumber, cDay
LOCAL cScreen, i, k

LOCAL aRow := {}, aCol := {}

dOldDate  := VALIDATE( dOldDate,  pOldDate, NIL)
dInitDate := VALIDATE( dInitDate, pDate,    NIL)
nTopRow   := VALIDATE( nTopRow,   pNumeric, NIL)
nLeftCol  := VALIDATE( nLeftCol,  pNumeric, NIL)
lShadow   := VALIDATE( lShadow,   pLogical, NIL)
aColors   := VALIDATE( aColors,   pArray,   NIL)

dOldDate  := IF( dOldDate =  NIL, dInitDate, dOldDate )
dInitDate := IF( dInitDate = NIL, DATE(), dInitDate)
lShadow   := IF( lShadow = NIL, .f., lShadow)

IF nTopRow = NIL

   nTopRow = IF(ROW() < MAXROW()/2, MAXROW()-pCalHeight-3, 3)
   ELSE
   nTopRow = IF(nTopRow > MAXROW()-pCalHeight-1, ;
		MAXROW()-pCalHeight-3, nTopRow)

ENDIF

IF nLeftCol = NIL

   nLeftCol = IF(COL() < MAXCOL()/2, MAXCOL()-pCalWidth-4, 2)
   ELSE
   nLeftCol = IF(nLeftCol > MAXCOL()-pCalWidth-2, ;
		 MAXCOL()-pCalWidth-4, nLeftCol)

ENDIF

IF !ISCOLOR()

   aColors := { 'W/N', 'W+/N', 'W/N', 'N/W', 'W+/N', 'N/W', ;
		   'N/W', 'W/N' }
   ELSE

   IF aColors = NIL

       aColors := { 'GR+/B', 'W+/B', 'W/B', 'W+/N+', 'W+/BG+',;
		    'W+/N+','W/N+', 'W/B' }

   ENDIF

ENDIF

cScreen    := FT_SAVRGN(nTopRow,nLeftCol,nTopRow+pCalHeight+1,;
			nLeftCol+pCalWidth+2)
dWorkDate  := dInitDate  // hold the calling date in case user
			 // escapes from this routine.
nOldCursor := SETCURSOR(0)

// define X/Y coordinates of calendar proper


FOR k = 1 TO 6

   FOR i = 1 TO 7

      AADD( aRow, k + nTopRow + 3)    // First row is nTopRow + 4
      AADD( aCol, (3*i-1) + nLeftCol) // First col is nLeftCol + 3

   NEXT

NEXT

// Draw Background calendar
DISPBEGIN()    // Use this function to "snap" the calendar
	       // onto the screen
SETCOLOR( aColors[pC_Info] )
@ nTopRow,nLeftCol CLEAR TO nTopRow+pCalHeight,nLeftCol+pCalWidth
@ nTopRow+11,nLeftCol+12 SAY pLine1b
@ nTopRow+12,nLeftCol+12 SAY pLine2b
@ nTopRow+13,nLeftCol+12 SAY pLine3b
@ nTopRow+14,nLeftCol+12 SAY pLine4b
@ nTopRow+15,nLeftCol+12 SAY pLine5b
@ nTopRow+16,nLeftCol+12 SAY pLine6b

SETCOLOR( aColors[pC_DOW] )
@ nTopRow+3,nLeftCol+3 SAY "S M  T  W  T  F  S" // days of the week

set color to gr+/b  &&  SETCOLOR( aColors[pC_InfoBox] )
@ nTopRow+11,nLeftCol+2 CLEAR TO nTopRow+16,nLeftCol+10
@ nTopRow+11,nLeftCol+2 SAY pLine1a
@ nTopRow+12,nLeftCol+2 SAY pLine2a
@ nTopRow+13,nLeftCol+2 SAY pLine3a
@ nTopRow+14,nLeftCol+2 SAY pLine4a
@ nTopRow+15,nLeftCol+2 SAY pLine5a
@ nTopRow+16,nLeftCol+2 SAY pLine6a
SETCOLOR( aColors[pC_Border] )
@ nTopRow, nLeftCol, nTopRow+pCalHeight, nLeftCol+pCalWidth BOX B_DOUBLE 
@ nTopRow+2, nLeftCol+1, nTopRow+10, nLeftCol+pCalWidth-1   BOX pSBar

DISPEND()

IF lShadow
   FT_SHADOW(nTopRow, nLeftCol+1, nTopRow+pCalHeight, ;
   	     nLeftCol+pCalWidth)
ENDIF

// Start of major program loop
DO WHILE !lExit

   // Day, Month, Year, first day, last day of month data

   nMonth     := MONTH(dWorkDate)
   nYear      := YEAR(dWorkDate)
   cYear      := STR(nYear)
   nDay       := DAY(dWorkDate)
   nLastDOM   := _FTLASTDAY(nMonth,nYear) // the day number of the
				       // last day in this month
   nFirstDOW  := DOW(CTOD(STR(nMonth,2)+'/01/'+cYear))
   nDayNumber := 0

   IF !lNewMonth // Redraw calendar if MORE than a day select occurs.

      SETCOLOR( aColors[pC_Title] )
      cMonth := CMONTH(dWorkDate) + ' ' + cYear
      @ nTopRow+1,nLeftCol+1 SAY SPACE(pCalWidth-2)
      @ nTopRow+1,nLeftCol+1 SAY SPACE((pCalWidth-LEN(cMonth))/2)+cMonth

      SETCOLOR( aColors[pC_PageBox] )
      @ nTopRow+4,nLeftCol+2 CLEAR TO nTopRow+9,nLeftCol+pCalWidth-2

   ENDIF

   DISPBEGIN()	// If key response is an issue (on slow machines)
		// remove this function.  With it in, the changes
		// "snap" onto the screen, but it does slightly
		// delay response.
   SETCOLOR( aColors[pC_AnyDate] )
   FOR nScrn_loc = nFirstDOW TO (nFirstDOW + nLastDOM - 1)

      cDay = STR(++nDayNumber,2)

      IF nDayNumber = DAY(dWorkDate) // Test for selected date &
				     // change color

	   SETCOLOR( aColors[pC_SelDate] )
	   @ aRow[nScrn_loc],aCol[nScrn_loc] SAY cDay
	   SETCOLOR( aColors[pC_AnyDate] )
	   LOOP

      ENDIF

      @ aRow[nScrn_loc],aCol[nScrn_loc] SAY cDay

   NEXT
   DISPEND()

   DO WHILE .T.  // Use this loop to prevent nonsense keys
		 // from redrawing the calendar.

     INKEY(0)
     nLastKey  := LASTKEY()
     lNewMonth := .F.  // Assume that user will change calendar month

     DO CASE

       CASE nLastKey == K_RIGHT 	// increase by one day
	 lNewMonth := EVAL(bChkMonth,dWorkDate,1)
	 dWorkDate++

       CASE nLastKey == K_LEFT		// decrease by one day
	 lNewMonth := EVAL(bChkMonth,dWorkDate,-1)
	 dWorkDate--

       CASE nLastKey == K_UP		// increase by seven days
	 lNewMonth := EVAL(bChkMonth,dWorkDate,-7)
	 dWorkDate := dWorkDate-7

       CASE nLastKey == K_DOWN		// decrease by seven days
	 lNewMonth := EVAL(bChkMonth,dWorkDate,7)
	 dWorkDate := dWorkDate+7

       CASE nLastKey == K_CTRL_HOME		// Control-Home key
	 dWorkDate := DATE()                    // System Date

       CASE nLastKey == K_HOME                  // Home Key
         dInitDate := dOldDate                  // Original Passed Date
         *lExit := .T.  && JR -- I don't like exiting here

       CASE nLastKey == K_ESC   // Exit no save
         dInitDate := dOldDate
         lExit := .T.

       CASE nLastKey == K_ENTER // Exit save
	 lExit := .T.
         keyboard chr(K_ENTER)   && JR - terminate the get with the new value

       CASE nLastKey == K_CTRL_UP  && K_PGUP		// page-up key	- back one month
	 nMonth--

	 IF nMonth < 1
	   nMonth := 12
	   nYear--
	 ENDIF

	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear)

       CASE nLastKey == K_MINUS 	// " - " - back one year
	 dWorkDate := _FTMAKDATE(nMonth,nDay,--nYear)

       CASE nLastKey == K_CTRL_PGDN 	// " - " - back one DECADE
	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear-10)

       CASE nLastKey == K_SH_PGDN 	// " - " - back one CENTURY
	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear-100)

       CASE nLastKey == K_CTRL_DN && K_PGDN		// page-down key - ahead one month

	 IF ++nMonth > 12
	   nMonth := 1
	   nYear++
	 ENDIF

	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear)

       CASE nLastKey == K_EQUAL .OR. nLastKey == K_PLUS
					// "= " - ahead one year
	 dWorkDate := _FTMAKDATE(nMonth,nDay,++nYear)

       CASE nLastKey == K_CTRL_PGUP  //  "  ahead one DECADE
	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear+10)

       CASE nLastKey == K_SH_PGUP  //  "  ahead one CENTURY
	 dWorkDate := _FTMAKDATE(nMonth,nDay,nYear+100)

       OTHERWISE
	 LOOP

     ENDCASE

     EXIT

   ENDDO

ENDDO

// Let's get out of here!

FT_RSTRGN(cScreen,nTopRow,nLeftCol)
SETCOLOR(cOldColor)
SETCURSOR(nOldCursor)

// return the date the user selected, or the calling date
// if user exited with Escape.

RETURN IF(nLastKey==K_ESC .or. nLastKey==K_HOME,dInitDate,dWorkDate)

/*************
*
*   Function _FTLASTDAY --> Returns last day of month as an integer
*/

STATIC FUNCTION _FTLASTDAY(nMonth,nYear)
LOCAL nLastDate

nLastDate := CTOD(STR(nMonth,2)+'/27/'+STR(nYear))

DO WHILE nMonth == MONTH(++nLastDate)
ENDDO

RETURN DAY(--nLastDate)

/*************
*
*    Function _FTMAKDATE --> Returns date as a string
*
*
*  Receives integers of the month day and year and returns
*  a composite date.
*  If day in month is greater than the true numbers in the
*  month it returns the last day.
*/

STATIC FUNCTION _FTMAKDATE(nMonth,nDay,nYear)
LOCAL dDate

IF nYear < 100
   nYear = 3000 - (100 - nYear)
else
   If nYear > 2999
      nYear = 100 + (nYear - 3000)
   endif
endif

dDate := CTOD(STR(nMonth,2)+'/'+STR(nDay,2)+'/'+STR(nYear))

IF dDate == CTOD(" / / ")
   dDate := CTOD(STR(nMonth,2)+'/'+STR(_FTLASTDAY(nMonth,nYear),2)+ ;
	     '/'+STR(nYear))
ENDIF

RETURN (dDate)

*---- DStart -----------------------------------------------------------------*

function DStart
* turn on special handling of keys for date changing


  cScreenm = FT_SAVRGN(24,2,24,79)
  dMESS()

  set key K_PLUS to DMove           && Assign procedure 
  set key K_MINUS to DMove          
  set key K_C to DMove
  set key K_c to DMove
  set key K_HOME to DMove
  set key K_CTRL_HOME to DMove
  *set key K_PGUP to DMove
  *set key K_PGDN to DMove
  set key K_CTRL_UP to DMove   && JR
  set key K_CTRL_DN to DMove   && JR
  set key K_CTRL_PGUP to DMove
  set key K_CTRL_PGDN to DMove
  set key K_ESC to DMove
 *  KEYBOARD CHR(K_C)

  return .t.

*----- DStop -----------------------------------------------------------------*

function DStop
* turn off special key handling for date changing & restore screen

  set key K_PLUS to                 && Change plus key back to normal
  set key K_MINUS to                && Change minus key back to normal
  set key K_C to
  set key K_c to
  set key K_HOME to
  set key K_CTRL_HOME to
  *set key K_PGUP to
  *set key K_PGDN to
  set key K_CTRL_UP to
  set key K_CTRL_DN to
  set key K_CTRL_PGUP to
  set key K_CTRL_PGDN to
  set key K_ESC to
  set Escape on
  
  FT_RSTRGN(cScreenm)  && ,24,2)
  save_cVar = NIL
 return .t.

*---DGetStop------------------------------------------------------------------*

Function DGetStop
dstop()
clear gets
return .t.

*----- DMove -----------------------------------------------------------------*

procedure DMove
* increment or decrement the passed variable if it is of date type
* if it's an empty date, set it to today's date

PARAMETER cProc, nLine, cVar


IF TYPE(cVar) == "D"              && If it is a date field
*if empty(save_cVar)
if save_cVar = NIL
   save_cVar = &cVar
endif

   do case
    case LASTKEY() == K_PLUS        && If the plus key was hit
       IF EMPTY(&cVar)                 && If it is empty
          &cVar = DATE()                && Set to today's date
       else
          &cVar = &cVar + 1           && Increment the date field
       endif

    case LASTKEY() == K_MINUS
       IF EMPTY(&cVar)                 && If it is empty
          &cVar = DATE()                && Set to today's date
       else
          &cVar = &cVar - 1           && Decrement the date field
       endif

    case LASTKEY() == K_C .or. LASTKEY() == K_c
       IF EMPTY(&cVar)
           &cVar = date()
       endif
       &cVar = FT_popupcal(&cVar, , ,.t., ,save_cVar)

    case LASTKEY() == K_HOME 
       &cVar = save_cVar

    case LASTKEY() == K_ESC
      &cVar = save_cVar
      set key K_ESC to DGETSTOP
      

    case LASTKEY() == K_CTRL_HOME
       &cVar = DATE()


   endcase

   if LASTKEY() != K_ESC
        set key K_ESC to DMove
   endif 

ENDIF

RETURN

*----DMESS--------------------------------------------------------------------*

Function DMESS
   d_mess = " +/- increments/decrements date -- ";
            + "C pops up Calendar " 
   && --- F1 = Help "
   @ 24, 2 say d_mess color if(iscolor(), "R/BG","W+/n")
return

*----DClrMess-----------------------------------------------------------------*
FUNCTION DClrMess
  @ 24,2 clear to 24, len(d_mess)
return

*-----------------------------------------------------------------------------*
