* FUNCTION.prg - 12/16/86
* User defined functions for use with Clipper programs.
* Additional functions added : 03/15/87
* Written by John Wright
*
*===========================================================================
*
* FUNCTION LIST
* -------------
* AGE        Calculate someone's age using the date of birth
* ALLTRIM    Trims a character field from front and back
* CHK_DATE   Check the date to be sure it is not ahead of current date
* ELAPSED    Calculate time between two time strings; return character string
* HOURTIME   Calculate time between two time strings; return numeric value
* NICEDATE   Returns a detailed string for a date value
* NICETIME   Returns a time string with am/pm designation
* NOVAL      Checks to see if variable value is entered.
* ONORAFT    Checks two dates to see if the second is on or after the first
* PROPR      Convert a character string to Proper case
* PUTCOMMA   Takes a numeric string and inserts commas to separate
* PUTPERCT   Takes a numeric string and converts it to a percent with % sign
* WEEKDAY    Checks to be sure the date is not on the weekend
*
* ==========================================================================

FUNCTION AGE
* Syntax: AGE( <date variable> )
* Calculates age given the date of birth and using the current date.
* Returns a character string containing the number of years old.
PARAMETER birthdate
STORE LTRIM(STR(INT((DATE()-birthdate)/365.25))) TO yearsold
RETURN yearsold


FUNCTION ALLTRIM
* Syntax: ALLTRIM( <character string> )
PARAMETER cl_string
RETURN LTRIM(TRIM(cl_string))


FUNCTION CHK_DATE
* Syntax: CHK_DATE( <date variable> )
* check to be sure the date is not in the "future"
PARAMETER datechk
IF datechk <= DATE()
 RETURN (.T.)
ENDIF
??CHR(7)     && BEEP IF INCORRECT
RETURN (.F.)


FUNCTION ELAPSED
* Syntax: ELAPSED( <time one>,<time two> )
* Given the two time strings: "12:30:45","13:46:17"
* elaptime = "1 hour, 15 minutes, 32 seconds"
PARAMETERS tc1,tc2

TH1=VAL(SUBSTR(TC1,1,2))
TM1=VAL(SUBSTR(TC1,4,2))
TS1=VAL(SUBSTR(TC1,7,2))
TT1=(TH1*3600)+(TM1*60)+TS1

TH2=VAL(SUBSTR(TC2,1,2))
IF TH2 < TH1
 TH2=TH2+24
ENDIF
TM2=VAL(SUBSTR(TC2,4,2))
TS2=VAL(SUBSTR(TC2,7,2))
TT2=(TH2*3600)+(TM2*60)+TS2

TTT=TT2-TT1

TTH=TTT/3600
TTH=INT(TTH)
IF TTH > 0
  IF TTH = 1
   STORE "1 hour, " TO elaptime
  ELSE
   STORE STR(TTH,2)+" hours, " TO elaptime
  ENDIF
 TTT=TTT-(TTH*3600)
ELSE
 STORE "" TO elaptime
ENDIF

TTM=TTT/60
TTM=INT(TTM)
IF TTM > 0
  IF TTM = 1
   STORE elaptime+"1 minute, " TO elaptime
  ELSE
   STORE elaptime+STR(TTM,2)+" minutes, " TO elaptime
  ENDIF
 TTT=TTT-(TTM*60)
ENDIF

TTS=TTT
IF TTS = 1
 STORE elaptime+"1 second" TO elaptime
ELSE
 STORE elaptime+STR(TTS,2)+" seconds" TO elaptime
ENDIF

RETURN elaptime


FUNCTION HOURTIME
* Syntax: HOURTIME( <time one>,<time two> )
* Given the two time strings: "12:30:45","13:46:17"
* hourtime = 1.25
PARAMETERS tc1,tc2

TH1=VAL(SUBSTR(TC1,1,2))
TM1=VAL(SUBSTR(TC1,4,2))
TT1=(TH1*3600)+(TM1*60)

TH2=VAL(SUBSTR(TC2,1,2))
IF TH2 < TH1
 TH2=TH2+24
ENDIF
TM2=VAL(SUBSTR(TC2,4,2))
TT2=(TH2*3600)+(TM2*60)

TTT=TT2-TT1

TTH=TTT/3600
 TTH=INT(TTH)
TTT=TTT-(TTH*3600)
 TTM=TTT/60
 TTM=INT(TTM)

STORE TTH+ROUND(TTM/60,2) TO hourtime
RETURN hourtime


FUNCTION NICEDATE
* Syntax: NICEDATE( <date variable> )
* Example: 12/25/86  =  December 25, 1986
PARAMETER dodate
RETURN CMONTH(dodate)+" "+LTRIM(STR(DAY(dodate)))+", "+STR(YEAR(dodate),4)


FUNCTION NICETIME
* Syntax: NICETIME( <time string> )
* Example: "14:25:23" = " 2:25pm"
PARAMETER dotime
STORE VAL(SUBSTR(dotime,1,2)) TO CHKTIME
STORE SUBSTR(dotime,3,3) TO ADDMIN
IF CHKTIME < 13
 STORE STR(CHKTIME,2)+ADDMIN+"am" TO showtime
ELSE
 STORE CHKTIME-12 TO CHKTIME
 STORE STR(CHKTIME,2)+ADDMIN+"pm" TO showtime
ENDIF
RETURN showtime


FUNCTION NOVAL
* Syntax: NOVAL( <numeric variable> )
* check to be sure something has been input for the variable
PARAMETERS numvar,rownum
IF numvar > 0
 RETURN (.T.)
ENDIF
??CHR(7)    && BEEP IF INCORRECT
RETURN (.F.)


FUNCTION ONORAFT
* Syntax: ONORAFT( <date variable>,<date variable> )
* check to be sure the second date is on or after the first date
PARAMETERS dateone,datetwo
IF datetwo >= dateone
 RETURN (.T.)
ENDIF
??CHR(7)    && BEEP IF INCORRECT
RETURN (.F.)


FUNCTION PROPR
* Syntax: PROPR( <character string> )
* Function design and code created by John Wright.
* This is a function designed to convert a character field to Proper case.
* (Clipper would not accept PROPER as a function name; therefore it is PROPR)
* CONVERT is the character string to convert
* FEND is the length of characters left in the end of the field
* FSIZE is the length of the actual character string
PARAMETER convert

STORE LEN(CONVERT)-1 TO FEND
STORE LOWER(CONVERT) TO CONVERT
STORE UPPER(SUBSTR(CONVERT,1,1))+SUBSTR(CONVERT,2,FEND) TO CONVERT

TEST="XXX"
STORE LEN(TRIM(CONVERT)) TO FSIZE
STORE AT(' ',CONVERT) TO BUF
CAP=BUF+1
AFT=CAP+1
STORE LEN(CONVERT) - CAP TO FEND
STORE SUBSTR(CONVERT,CAP,1) TO TEST

DO WHILE TEST <> " "
STORE SUBSTR(CONVERT,1,BUF)+UPPER(SUBSTR(CONVERT,CAP,1))+;
SUBSTR(CONVERT,AFT,FEND) TO CONVERT
STORE SUBSTR(CONVERT,AFT,FEND) TO SECTION
STORE SUBSTR(CONVERT,CAP,1) TO TEST
STORE AT(' ',SECTION) TO BUF
IF BUF <= 0
TEST=" "
ELSE
 BUF=CAP+BUF
 CAP=BUF+1
 IF CAP <= FSIZE
  AFT=CAP+1
  STORE LEN(CONVERT) - CAP TO FEND
 ENDIF
 IF CAP > FSIZE
  TEST=" "
 ENDIF
ENDIF
ENDDO
RETURN convert


FUNCTION PUTCOMMA
* Syntax: PUTCOMMA( <numeric variable>,<numeric value>,<numeric value> )
* create a character string from a numeric string; including commas!!!
* nv1 = number to convert
* nv2 = length of string to return
* nv3 = number of decimal places
* maximum numeric value: 999,999,999
PARAMETERS nv1,nv2,nv3
 IF TYPE("nv3") = "N"
  * if decimal number is sent then adjust for it
  STORE STR(nv1,10+nv3,nv3) TO SPLIT
  STORE 4+nv3 TO REST
 ELSE
  * assumes 0 decimal places
  STORE STR(nv1,9) TO SPLIT
  STORE 3 TO REST
 ENDIF
 DO CASE
  CASE nv1 > 999999
   SHOW=SUBSTR(SPLIT,1,3)+","+SUBSTR(SPLIT,4,3)+","+SUBSTR(SPLIT,7,REST)
  CASE nv1 > 999
   SHOW=SUBSTR(SPLIT,1,6)+","+SUBSTR(SPLIT,7,REST)
  CASE nv1 < 1000
   SHOW=SPLIT
 ENDCASE
 STORE LTRIM(SHOW) TO SHOW
 IF LEN(SHOW) > nv2
  * return "*"s because number is greater than maximum space available
  RETURN REPLICATE("*",nv2)
 ELSE
  * add spaces to the left of SHOW variable
  STORE nv2 - LEN(SHOW) TO GAP
  STORE SPACE(GAP)+SHOW TO SHOW
 ENDIF
RETURN SHOW


FUNCTION PUTPERCT
* Syntax: PUTPERCT( <numeric variable>,<numeric value>,<numeric value> )
* alter a numeric string to display as a percent; including % sign!!!
* nv1 = number to convert
* nv2 = length of string to return
* nv3 = number of decimal spaces
PARAMETERS nv1,nv2,nv3
IF TYPE("nv3") = "U"
 STORE 0 TO nv3
ENDIF
STORE nv2 - 1 TO NV4
STORE nv1*100 TO NV5
STORE ROUND(NV5,nv3) TO PART1
STORE STR(PART1,NV4,nv3) TO PART2
STORE PART2+"%" TO SHOW
RETURN SHOW


FUNCTION WEEKDAY
* Syntax: WEEKDAY( <date variable> )
* check to be sure the date is not on the weekend
PARAMETERS datechk
IF DOW(datechk) > 1 .AND. DOW(datechk) < 7
 RETURN (.T.)
ENDIF
??CHR(7)    && BEEP IF INCORRECT
RETURN (.F.)