* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program.:      Plusutil.prg  A debugging aid                              *
* Formats programs with indents. Comments follow endif, enddo && like this. *
* Upgrade of db3util which bombs on negative indents & has other problems.  *
* Plusutil marks illegal code; lists unfinished loops at end.               *
* Requires  plus.DBF  (Only need to create it once)                         *
*                                                        Feedback to:       *
*               Structure for database: PLUS.DBF          Norm Smith        *
*               Field  Field Name  Type       Width       415/548-9497      *
*                   1     LINE     Character    254                         *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET TALK OFF
CLEAR ALL
USE plus
SET SAFETY OFF
ZAP
SET SAFETY ON
fle=" "
newfle=" "
CLEAR
DO WHILE fle=" "
  CLEAR
  ? "(Both default to .PRG)"
  ACCEPT "INPUT PRG FILE NAME :" TO fle
  fle=TRIM(fle)
  a=AT(".",fle)
  IF a=0
    fle=fle+".prg"
  ENDIF { a=0}
  IF .NOT. FILE(fle)
    ? fle+" not found"
    WAIT
    fle=" "
    LOOP
  ENDIF { .NOT. FILE(fle)}
ENDDO { WHILE fle=" "}
DO WHILE newfle= " "
  ACCEPT "OUTPUT FILE NAME:" TO newfle

  newfle=TRIM(newfle)
  a=AT(".",newfle)
  IF a=0
    newfle=newfle+".prg"
  ENDIF { a=0}
  IF FILE(newfle)
    ? newfle+" exists. Choose another Name"
    wait
    newfle=" "
    LOOP
  ENDIF { FILE(newfle)}
ENDDO { WHILE newfle= " "}
APPEND FROM &fle SDF
GOTO TOP
CLEAR
SET ALTERNATE TO &newfle
SET ALTERNATE ON
? "* ** "+newfle+" ("+DTOC(DATE())+" - "+TIME()+")"
seq=" "
indent=0
errmes=" NOT EXPECTED! "
comment=0
DO WHILE .NOT. EOF()
  m=ltrim(TRIM(line))
  um=left(UPPER(m),4)
  DO CASE
  CASE um= "TEXT"
    DO WHILE .NOT. um="ENDT"
      ? TRIM(line)
      SKIP
      m=ltrim(TRIM(line))
      um=left(UPPER(m),4)
    ENDDO { WHILE .NOT. um="ENDT"}
    ? SPACE(indent)+ "ENDTEXT"
  CASE um="IF"
    seq="I"+seq
    comment=comment+1
    c="C"+ltrim(STR(comment))
    cm=TRIM(SUBSTR(m,AT(" ",m),250))
    IF LEN(cm) > 35
      cm=TRIM(left(cm,35))+"...etc."
    ENDIF { LEN(cm) > 35}
    &c= " "+chr(38)+chr(38)+" "+cm
    ? SPACE(indent)+m
    indent=indent+2

  CASE um="ELSE"
    IF left(seq,1)="I"
      ? SPACE(indent-2)+"ELSE"
      seq="E"+seq
    ELSE
      ? "***ELSE "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
    ENDIF { left(seq,1)="I"}

  CASE um= "ENDI"
    IF left(seq,1) $ "EI"
      indent=indent-2
      c="C"+ltrim(STR(comment))
      comment=comment-1
      ? SPACE(indent)+"ENDIF"+&c
      IF left(seq,1)="E"
        seq=right(seq,LEN(seq)-2)
      ELSE
        seq=right(seq,LEN(seq)-1)
      ENDIF { left(seq,1)="E"} 
    ELSE
      ? SPACE(indent)+"***ENDIF "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
      
    ENDIF { left(seq,1) $ "EI"} 
    
  CASE um="DO W"
    seq="W"+seq
    comment=comment+1
    c="C"+ltrim(STR(comment))
    cm=TRIM(SUBSTR(m,AT(" ",m),250))
    IF LEN(cm)>35
      cm=TRIM(left(cm,35))+"...etc."
    ENDIF { LEN(cm)>35} 
    &c=" "+chr(38)+chr(38)+" "+cm
    ? SPACE(indent)+m
    indent=indent+2
    
  CASE um="ENDD"
    IF left(seq,1) ="W"
      indent=indent-2
      c="C"+ltrim(STR(comment))
      comment=comment-1
      ? SPACE(indent)+"ENDDO"+ &c
      seq=right(seq,LEN(seq)-1)
    ELSE
      ? SPACE(indent)+"***ENDDO "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
    ENDIF { left(seq,1) ="W"} 
    
  CASE um="DO C"
    indent=indent+2
    seq="C"+seq
    ? SPACE(indent-2)+"DO CASE"

  CASE um="CASE"
    IF left(seq,1) $ "AC"
      ? SPACE(indent-2)+m
      seq="A"+seq
    ELSE
      ? SPACE(indent-2)+"***"+M+" "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
    ENDIF { left(seq,1) $ "AC"} 
    
  CASE um="OTHE"
    IF left(seq,1) $ "AC"
      sq=seq+"O"
      ? SPACE(indent-2)+"OTHERWISE"
    ELSE
      ? SPACE(indent-2)+"***OTHERWISE "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
      
    ENDIF { left(seq,1) $ "AC"} 
    
  CASE um="ENDC"
    IF left(seq,1) $ "OAC"
      indent=indent-2
      IF left(seq,1)="O"
        seq=right(seq,LEN(seq)-1)
      ENDIF { left(seq,1)="O"} 
      DO WHILE left(seq,1)="A"
        seq=right(seq,LEN(seq)-1)
      ENDDO { WHILE left(seq,1)="A"} 
      seq=right(seq,LEN(seq)-1)
      ? SPACE(indent)+"ENDCASE"
    ELSE
      ? SPACE(indent)+"***ENDCASE "+errmes
      DO CASE
      CASE left(seq,1) $ "EI"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDIF "+&C
      CASE left(seq,1) $ "AC"
        ?? "***MISSING an ENDCASE"
      CASE left(seq,1)="W"
        c="C"+ltrim(STR(comment))
        ?? "***MISSING an ENDDO "+&C
      ENDCASE
    ENDIF { left(seq,1) $ "OAC"} 
    
  OTHERWISE
    ? SPACE(indent)+m
  ENDCASE
  SKIP
ENDDO { WHILE .NOT. EOF()}
IF LEN(TRIM(seq))>0
  ? "*** Remaining in sequence :",TRIM(seq)
  ? "*** ========================"
  ? "*** I = If"
  ? "*** E = Else"
  ? "*** C = Do Case"
  ? "*** A = CASE"
  ? "*** O = Otherwise"
  ? "*** W = Do While"
ENDIF { LEN(TRIM(seq))>0}
SET ALTERNATE OFF
CLOSE ALTERNATE

