/*
 Ŀ
ݳ   Application...: Pat.prg                                                
ݳĳ
ݳ   ORIGINAL                                                               
ݳ   Programmer....: John Agusta                                            
ݳ   Date..........: August 22, 1990                                        
ݳ                                                                          
ݳ   LAST MODIFICATION                                                      
ݳ   Author........: John Agusta                                            
ݳ   Date..........: July 10, 1992                                          
ݳ   Notes.........: Allows for creation, editing and testing of printer    
ݳ                   definitions.                                           
ݳ                                                                          
ݳ   Compile.......: clipper pat /n /w                                      
ݳ                   clipper rpt /n /w                                      
ݳ                                                                          
ݳ   Link..........: rtlink fi pat, rpt, prtcodes                           
ݳ                                                                          
ݳ   Parameters....: None                                                   
ݳ                                                                          
ݳ   Functions.....: Main(), FlRght(), SayCenter(), MenuChoice()            
 

*/
Function Main()
LOCAL cAction, ;
      cDefPrinter,      ; // default printer
      acPrinterDefs,    ; // User selectable printer definitions
      cPFSpec             // Path where PAT_DEFS.DBF is found

Scroll()

// Get rid of unwanted public variable imposed by Clipper
Release GetList

/* 
The next two variables should typically be saved 
in some sort of user profile configuration file.  I have
hard-coded them here for example only
*/
cPFSpec     := "PAT_DEFS"
cDefPrinter := "LASERJET"

/*
By commenting out the next line, you can select any printer
in the printer definition database.  This way restricts the
selection to the printer IDs specified in the array.  Again, 
this information should be typically stored in a user configuration
file.
*/
acPrinterDefs := { {"LASERJET", "LPT1"}, ;
                   {"EPSON", "LPT1"}, ;
                   {"CANON", "LPT1"}, ;
                   {"STANDARD", "DUMP.PRN"} }

// Set printer to port associated with default printer
SetUserPort(cDefPrinter, acPrinterDefs)
// Initialize statics in PRTCODES.PRG
If !InitPAT(cDefPrinter, cPFSpec, acPrinterDefs)
   ? "Unable to initialize PAT system, press any key to continue"
   Inkey(0)
Endif

Do While .T.

  GenScrn("MAIN MENU", "PAT Maintenance System")

  @ 8, 3       Say "1. Printer Action Table Maintenance"
  @ Row()+1, 3 Say "2. Test Printer Codes"
  @ Row()+1, 3 Say "3. Change selected printer"
  @ Row()+1, 3 Say "4. Run Sample Report"
  @ Row()+2, 3 Say "0. Quit"

  @ 18,3 Say 'Enter Selection ===>'

  cAction := MenuChoice('12340')

  Do Case
     Case cAction == '1'
        MakePat()
     Case cAction == '2'
        TestPat()
     Case cAction == '3'
        If SelPrntr()
           SetUserPort(DefPrntr(), acPrinterDefs)
        Endif
     Case cAction == '4'
        Rpt()
     Case cAction == '0'
        Exit
  EndCase

ENDDO

Scroll()

Return NIL
*EOF Main()


/*
 Ŀ
ݳ   Function......: GenScrn()                                              
ݳĳ
ݳ   ORIGINAL                                                               
ݳ   Programmer....: John Agusta                                            
ݳ   Date..........: October 17, 1991                                       
ݳ                                                                          
ݳ   LAST MODIFICATION                                                      
ݳ   Author........: John Agusta                                            
ݳ   Date..........: November 5, 1991                                       
ݳ   Notes.........: Creates generic screen                                 
ݳ                                                                          
ݳ   Parameters....: cStr1    CHARACTER                                     
ݳ                      Character string used to describe menu              
ݳ                   cStr2    CHARACTER                                     
ݳ                      Character string used to describe application       
ݳ                                                                          
ݳ   Returns.......: NIL                                                    
 

*/
Function GenScrn(cStr1, cStr2)
Local cPrinterID

cPrinterID := DefPrntr()

Scroll()
@ 1,2 Say "ACME Inc."
@ 2,2 Say DtoC(Date())
@ 3,2 Say Replicate(Chr(196),MaxCol()-3)
@ 5,2 Say Replicate(Chr(196),MaxCol()-3)

@ 0,0 to MaxRow(), MaxCol() Double

SetColor("I")
SayCenter(4, MaxCol(), " " + cStr1 + " ")
SetColor("")

@ MaxRow()-1,3 Say "Program Version: 1.03"

If cPrinterID <> NIL
   FlRght("Selected Printer: " + cPrinterID, MaxRow()-1, MaxCol()-2)
Endif

Return NIL

* John Charles Agusta
* 8/13/89

FUNCTION FlRght(Str, URow, Wid, SubLen)
*  Returns string flush right using value passed from variable WID
*  Returns sub-string of value specified by optional variable SubLen
*
*  Syntax:  FlRght(<expC>,<expN1>,<expN2>,[<expN3>])
*
*  Ex.      FlRght("Vessel Certificate Status System",79,2)
LOCAL POS

Wid := If(WID == NIL, MaxCol(), WID)

SubLen  := If(SubLen == NIL, 0, SubLen)

Pos := Wid - Len(Str) + 1

@ URow, Pos Say IIF(SubLen == 0, Str, Substr(Str,1,SubLen))

Return NIL


*********************************************
* SayCenter()         Say this text at Center
*********************************************
FUNCTION SAYCENTER(cl_line, cl_len, cl_string)
* Syntax ..... SAYCENTER( <expN1> , <expN2> , <expC1> )
*                 expN1 = Row
*                 expN2 = Width of Line
*                 expC  = Character String to center.
*
* Performs.... @ say on expN1, Centered between 0 and expN2, the String ExpC.
*
*   Note ..... This Function can be use on a line by itself.
*  Examp ..... SAYCENTER(10,79,"test") will display on line 10,
*                          centered between 0 and 79 the word "test"
*

@ cl_line, IF(len(cl_string) < cl_len, (cl_len - len(cl_string)) / 2,0) say cl_string
return NIL


Function MenuChoice(AllowChr)

LOCAL I, mCol, mRow

mCol    := Col()
mRow    := Row()
i       := 0

DO WHILE i == 0
   i := INKEY()
   @ mRow, mCol SAY ""
   IF UPPER(CHR(i)) $ AllowChr
      EXIT
   ENDIF
   i := 0
ENDDO 

@ mRow,mCol SAY UPPER(CHR(i))

Return UPPER(CHR(i))

