/* PIECLIP.C by Dennis Courtney - a PIECHART for Clipper S'87  */

#include <graph.h>
#include <math.h>
#include <string.h>
#include "nandef.h"
#include "extend.h"

#define SCREEN_HEIGHT 3
#define SCREEN_WIDTH  4
#define RAD     500
#define PI      3.1415927
#define TRUE    1

/* Resolution values
 _MRES4COLOR     320 x 200, 4 color
 _MRESNOCOLOR    320 x 200, 4 grey
 _HRESBW         640 x 200, BW
 _HERCMONO       720 x 348, BW for HGC
 _MRES16COLOR    320 x 200, 16 color
 _HRES16COLOR    640 x 200, 16 color
 _ERESNOCOLOR    640 x 350, BW
 _ERESCOLOR      640 x 350, 4 or 16 color
 _VRES2COLOR     640 x 480, BW
 _VRES16COLOR    640 x 480, 16 color
 _MRES256COLOR   320 x 200, 256 color
 videoconfig adapter values
 _MDPA       0x0001       Monochrome Display Adapter (MDPA)
 _CGA        0x0002       Color Graphics Adapter     (CGA)
 _EGA        0x0004       Enhanced Graphics Adapter  (EGA)
 _VGA        0x0008       Video Graphics Array       (VGA)
 _MCGA       0x0010       MultiColor Graphics Array  (MCGA)
 _HGC        0x0020       Hercules Graphics Card     (HGC)
  end of values */


CLIPPER pieclip()
{
    struct videoconfig gr_info, far *p_gr;
    double dataSum = 0.00, startAngle, endAngle, relAngle;
    double startVecX, startVecY, endVecX, endVecY, aspect;
    int j, k, n, mode, left, top, right, bot, offsetx, offsety;
    int xctr, yctr, xrad, yrad, mask = 0, fill, rfill, xz;
    int btopx, btopy, bbotx, bboty, nocolor = 0, data[12];
    float pct;
    short color;
    char buffer[81], title1[81], title2[81], foot[81], notice[81],
         label[12] [21];
    
    if (_parni(1) > 12)
        n = 12;
    else
        n = _parni(1);
    if (_parinfo(0) > 3)
    {
        strcpy(title2,_parc(4,2));
        strcpy(title1,_parc(4,1));
        strcpy(foot,_parc(4,3));
    }
    
    p_gr = _getvideoconfig(&gr_info);
    switch(p_gr->adapter)
    {
        case _CGA:
            if (p_gr->monitor != _MONO)
                mode = _MRES4COLOR;
            else
                mode = _HRESBW;
            break;
        case _EGA:
            if (p_gr->monitor == _MONO)
            {
               mode = _ERESNOCOLOR;
               break;
            }
            if (p_gr->numypixels <= 200)
                mode = _HRES16COLOR;
            else
                mode = _ERESCOLOR;
            break;
        case _VGA:
            if (p_gr->monitor == _MONO)
              mode = _ERESNOCOLOR;
            else
              mode = _ERESCOLOR;
            break;
        case _HGC:
            mode = _HERCMONO;
            break;
    }
    if (p_gr->monitor == _MONO)
    {
      nocolor = TRUE;
      mask = TRUE;
    }

    if (_setvideomode(mode)==0)
    {
        printf("\nUnable to set video mode %d.",mode);
        _retl(0);
    }
    
    strcpy(notice,"Press any key to continue...");
    p_gr = _getvideoconfig(&gr_info);
    
    offsety = (int) (p_gr->numypixels / 25);
    offsetx = (int) (p_gr->numxpixels / 80);
    aspect = (float) (SCREEN_WIDTH * p_gr->numypixels) /
             (float) (SCREEN_HEIGHT * p_gr->numxpixels);
    if (mode != _MRES4COLOR)
    {
        xctr = (int) (p_gr->numxpixels * .7);
        yctr = (int) (.7 * p_gr->numypixels);
        xrad = 175;
        yrad = 175;
        _settextposition(1,40 - (strlen(title1) / 2));
        _outtext(title1);
        _settextposition(2,40 - (strlen(title2) / 2));
        _outtext(title2);
    }
    else
    {
        
        xctr = (int) (320 * .6);
        yctr = 115;
        xrad = 75;
        yrad = 75;
        _selectpalette(2);
        _settextposition(1,20 - (strlen(title1) / 2));
        _outtext(title1);
        _settextposition(2,20 - (strlen(title2) / 2));
        _outtext(title2);
    }
    left = (xctr-xrad);
    top = (yctr-yrad);
    right =  (xctr+xrad);
    bot = (yctr+yrad);
    for (j = 0, k = 1; j < n; j++, k++)
    {
        data[j] = _parnl(2,k);
        if (_parinfo(0) > 2)
        {
            if (mode > _MRES4COLOR)
                strncpy(label[j],_parc(3,k),20);
            else
                strncpy(label[j],_parc(3,k),6);
        }
    }
    
    for (j = 0; j < n; j++)
        dataSum += data[j];
    endAngle = 0;
    for ( j = 0; j < n; j++)
    {
        
        startAngle = endAngle;
        relAngle = 2 * PI * data[j] / dataSum;
        endAngle = startAngle + relAngle;
        if (data[j] <= 0)
        {
            data[j] = 0;
            fill = _GBORDER;
            rfill = _GFILLINTERIOR;
        }
         else
            fill = rfill = _GFILLINTERIOR;
        if (mode == _MRES4COLOR)
        {
            _setcolor( 1 + j % 3);
            _settextcolor( 1 + j % 3);
            if ((j >= 3) && (j <= 5))
                fill = rfill = _GBORDER;
            if ((j >= 6) && (j <= 8))
            {
                fill = rfill = _GFILLINTERIOR;
                fill_mask(2);
            }
            if (j >= 9)
            {
                fill_mask(4);
                fill = rfill = _GFILLINTERIOR;
            }
        }
        else
        {
            if (nocolor)
                _setcolor(15);
            else
            {
                _setcolor( j + 1);
                _settextcolor( j + 1);
            }
        }
        if ((p_gr->monitor == _MONO) || (mask == 1))
            fill_mask(j);
        startVecX = xctr + RAD * cos(startAngle);
        startVecY = yctr - RAD * sin(startAngle);
        endVecX = xctr + RAD * cos(endAngle);
        endVecY = yctr - RAD * sin(endAngle);
        _pie(fill, left,(int)(top*aspect), right,(int)(bot*aspect),
        startVecX,(int)(startVecY*aspect), endVecX,(int)(endVecY*aspect));
        pct = (data[j] / dataSum) * 100;
        sprintf(buffer,"%s",label[j]);
        if (mode > _MRES4COLOR)
            _settextposition(j+9,5);
        else
            _settextposition(j+9,3);
        btopx = 1;
        btopy = (offsety * (j+8))-1;
        bbotx = btopx + (offsetx * 3);
        bboty = btopy + (offsety);
        _rectangle(rfill,btopx,btopy,bbotx,bboty);
        color = _getcolor();
        _setcolor(0);
        if (rfill != _GBORDER)
            _rectangle(_GBORDER,btopx,btopy,bbotx,bboty);
        _setcolor(color);
        _outtext(buffer);
        strset(buffer,'\0');
    }
    if (mode > _MRES4COLOR)
        _settextcolor(7);
    _settextposition(24,1);
    _outtext(foot);
    _settextposition(25,1);
    _outtext(notice);
    getch();
    _clearscreen(_GCLEARSCREEN);
    _settextposition(25,1);
    _outtext("Please wait while resetting video mode...");
    for(xz = 0;xz < 500; xz++);
    _clearscreen(_GCLEARSCREEN);
    _setvideomode(_DEFAULTMODE);
    _retl(1);
}

fill_mask(int i)
{
    unsigned char fillmask[4] [8];
    fillmask [0] [0] = 1;
    fillmask [0] [1] = 3;
    fillmask [0] [2] = 7;
    fillmask [0] [3] = 0xf;
    fillmask [0] [4] = 0x1f;
    fillmask [0] [5] = 0x3f;
    fillmask [0] [6] = 0x7f;
    fillmask [0] [7] = 0xff;
    fillmask [1] [0] = 0xf0;
    fillmask [1] [1] = 0xf0;
    fillmask [1] [2] = 0xf0;
    fillmask [1] [3] = 0xf0;
    fillmask [1] [4] = 0xf;
    fillmask [1] [5] = 0xf;
    fillmask [1] [6] = 0xf;
    fillmask [1] [7] = 0xf;
    fillmask [2] [0] = 0xcc;
    fillmask [2] [1] = 0x33;
    fillmask [2] [2] = 0xcc;
    fillmask [2] [3] = 0x33;
    fillmask [2] [4] = 0xcc;
    fillmask [2] [5] = 0x33;
    fillmask [2] [6] = 0xcc;
    fillmask [2] [7] = 0x33;
    fillmask [3] [0] = 0xc3;
    fillmask [3] [1] = 0xc3;
    fillmask [3] [2] = 0xc;
    fillmask [3] [3] = 0xc;
    fillmask [3] [4] = 0x30;
    fillmask [3] [5] = 0x30;
    fillmask [3] [6] = 0xc3;
    fillmask [3] [7] = 0xc3;
    _setfillmask(fillmask[2 * i - 1]);
}
