* LOOKUP PICK LIST FROM TEXT FILE
* CLIPPER 5.0 VERSION
*
* PARAMETERS
*    TFILE      TEXT FILE NAME
*    TFLD       TARGET FIELD NAME
*    NOEXIT     LOGICAL TO REQUIRE SELECTION
*    UPROC      NAME OF USER PROCEDURE TO EXECUTE AFTER SELECTION
*    TL         TOP LINE OF PICK LIST WINDOW
*    TC         TOP LEFT COLUMN OF PICK LIST WINDOW
*    BL         BOTTOM LINE OF PICK LIST WINDOW
*    BC         BOTTOM RIGHT COLUMN OF PICK LIST WINDOW
*    CLRS       COLOR STRING FOR PICK LIST
*
* EXAMPLE CALL
*    TLOOKUP('TEXT FILE','FIELD',REQUIRED,'USER PROC(OPTIONAL)',TL,TC,BL,BC,'COLOR STRING')
*
*    TEXT FILE SHOULD CONTAIN A LINE FOR EACH ENTRY TERMINATED BY CR/LF PAIR
*
FUNCTION PICKLIST
PARAMETERS TFILE,TFLD,NOEXIT,UPROC,TL,TC,BL,BC,CLRS
LOCAL BUFF,CNT,X,ENTRY,BUFFLEN,LSAVE,LCLR
M->BUFF = MEMOREAD(M->TFILE)
M->BUFFLEN = LEN(M->BUFF)
IF M->BUFFLEN = 0
  ERR_MSG(TFILE+' IS EMPTY, CAN NOT PERFORM LOOKUP')
  RETURN .T.
ENDIF           
ENTRYS := {}
M->X = 1
M->ENTRY = ''
DO WHILE M->X <= M->BUFFLEN
  IF !SUBSTR(M->BUFF,M->X,1)$CHR(13)+CHR(10) .AND. M->X <= M->BUFFLEN
    M->ENTRY = M->ENTRY + SUBSTR(M->BUFF,M->X,1)
  ELSE
    IF SUBSTR(M->BUFF,M->X,1)$CHR(13)+CHR(10)
      IF !EMPTY(M->ENTRY)
        AADD(ENTRYS,PAD(M->ENTRY,LEN(&TFLD)))
        M->ENTRY = ''      
      ENDIF
      IF SUBSTR(M->BUFF,M->X+1,1)$CHR(13)+CHR(10)
        M->X = M->X + 1
      ENDIF
    ENDIF
  ENDIF
  M->X = M->X + 1
ENDDO                  
M->CNT = LEN(ENTRYS)
IF ASCAN(ENTRYS,&TFLD) <> 0
  RETURN .T.
ENDIF
M->LSAVE = SAVESCREEN(M->TL,M->TC,M->BL,M->BC)
IF PCOUNT() > 8
  M->LCLR = SETCOLOR(M->CLRS)
ELSE
  M->LCLR = SETCOLOR()
ENDIF
@ M->TL,M->TC TO IF(M->TL+M->CNT > M->BL,M->BL,M->TL+1+M->CNT),M->BC DOUBLE
IF M->NOEXIT
  M->X = 0
  DO WHILE M->X = 0
    M->X = ACHOICE(M->TL+1,M->TC+1,IF(M->TL+M->CNT > M->BL-1,M->BL-1,M->TL+M->CNT),M->BC-1,ENTRYS)
  ENDDO
ELSE
  M->X = ACHOICE(M->TL+1,M->TC+1,IF(M->TL+M->CNT > M->BL-1,M->BL-1,M->TL+M->CNT),M->BC-1,ENTRYS)
ENDIF
IF !EMPTY(M->UPROC)
  DO &UPROC
ENDIF
IF M->X > 0
  &TFLD = ENTRYS[M->X]
ENDIF
SETCOLOR(M->LCLR)
RESTSCREEN(M->TL,M->TC,M->BL,M->BC,M->LSAVE)
RETURN .T.
