
* Function: CENTERBOX
* Author..: GARY BLATT
* Syntax..: CENTER( exp<N>, exp<C> )
*           <expN> = row number to display message. Must be >=1 & <=23
*           <expC> = string to display
* Returns.: .T. if executed ok, .F. if not
FUNCTION CENTERBOX
PARAMETERS p1, p2, p3, p4

PNUM=PCOUNT()
** calculate left and right column
do case
   case pnum=2
         lcol=(80-len(p2))/2
         rcol=lcol+len(p2)
   case pnum=3
         lcol=min((80-len(p2))/2, (80-len(p3))/2)
         rcol=lcol+max(len(p2), len(p3))
   case pnum=4
         ltmp=min((80-len(p2))/2, (80-len(p3))/2) 
         lcol=min(ltmp, (80-len(p4))/2)      
         rtmp=max(len(p2), len(p3))
         rcol=lcol+max(rtmp, len(p4))
endcase

** DRAW BOX ON SCREEN
@ p1-1,lcol-1,p1+(pnum-1),rcol BOX 'ͻȺ'

** display message on screen
do case
   case pnum=2
      @ p1,(80-LEN(p2))/2 SAY p2
         return .t.
   CASE PNUM=3
      @ P1,(80-LEN(P2))/2 SAY P2
      @ P1+1,(80-LEN(P3))/2 SAY P3
      RETURN .T.
   CASE PNUM=4
      @ P1,(80-LEN(P2))/2 SAY P2
      @ P1+1,(80-LEN(P3))/2 SAY P3
      @ P1+2,(80-LEN(P4))/2 SAY P4
      RETURN .T.
ENDCASE

* Function: nameDATE
* Author..: Gary Blatt
* Syntax..: NAMEDATE( [<expD>] )
* Returns.: Date variable as character string in the form: Monday January 1, 1986
*

FUNCTION NAMEDATE

PARAMETERS rl_date

*-- verify parameter exists and/or is a date type variable
IF .NOT. TYPE('rl_date') = 'D'                            
   *-- if not date type, or undefined, default to system date
   rl_date = DATE()
ENDIF

*-- return character string of the: Month + space + Day + comma + Year
RETURN ( cdow(rl_date)+' '+CMONTH(rl_date) + ' ' + LTRIM(STR(DAY(rl_date),2,0)) + ', '+;
         STR(YEAR(rl_date),4,0) )
