********
* Function: FNTXCAT
* Author  : Gary Blatt
* Date    : April 14, 1989
* Syntax  : FNTXCAT(<expC1>,<expC2>)
*           where <expC1> = index file name, without extension
*                 <expC2> = database filename to be inserted            
* Usage   : Call this function after each index/reindex to insert dbf name
*           into the ntx file. Then use program listntx to display info.

FUNCTION FNTXCAT
PARAMETERS NTX_name,DBF_name

*** close index file if open
set inde to

*** open index file
inHANDLE = fopen("&ntx_name..ntx")
if ferror() <> 0
   set inde to &ntx_name
   return .f.
endif 

*** set up temporary output file
outhandle= fcreate('tmp.fil')

*** get total file length
FLEN = fseek(inHANDLE,0,2)

*** reset file pointer to beginning
fseek(inHANDLE,0)

*** read 1st 1008 bytes & put into buffer1
block=1008
buffer=spac(1008)
fread(inHANDLE,@buffer,block)
buffer1 = buffer

*** move file pointer by 8 bytes & read rest of file into buffer2
fseek(inhandle,8,1)
block=flen-1016
buffer=spac(flen-1016)
fread(inhandle,@buffer,block)
buffer2=buffer

*** set string for output file
obuffer=buffer1+pad(dbf_name,8)+buffer2

*** write string to output file
fwrite(outhandle,obuffer)

*** close input & output files
fclose(inhandle)
fclose(outhandle)

*** rename tmp.fil to original name
erase &ntx_name..ntx
rename tmp.fil to &ntx_name..ntx

*** reopen index file if called with open database
if .not. empty(alias())
   set inde to &ntx_name
endif
return .t.
