/*
 * File......: PEEK.C
 * Author....: Ted Means
 * Date......: $Date:   17 Aug 1993 19:40:16  $
 * Revision..: $Revision:   1.1  $
 * Log file..: $Logfile:   C:/nanfor/src/exo/peek.c_v  $
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   C:/nanfor/src/exo/peek.c_v  $
 * 
 *    Rev 1.1   17 Aug 1993 19:40:16   GLENN
 * Dieter Smode [CIS ID: 100034,243] noticed that the function creates a
 * protected mode pointer but does not release the selector from the
 * descriptor table.  Due to successive calls to FT_PEEK, the descriptor table
 * would overflow.  Fixed.
 * 
 *    Rev 1.0   15 Jul 1993 22:46:16   GLENN
 * Initial revision.
 * 
 */

/* Librarian's note:
 *
 * This source code is for a special version of ft_peek(), compatible
 * with the ExoSpace (tm) DOS Extender from SofDesign, International.
 * It is ExoSpace-specific and is maintained separately from the real
 * mode version.
 *
 * The documentation can be found in the real-mode PEEK.C as
 * distributed with the regular Nanforum Toolkit.
 *
 */ 


#include "extend.h"

void *      ExoProtectedPtr(void *rmptr, unsigned int sizebytes);
int         ExoFreeSelector(unsigned int);

CLIPPER FT_PEEK(void)
{
   auto unsigned char * byteptr;
   auto unsigned char * pmptr;

   if ( (PCOUNT >= 2) && (ISNUM(1)) && (ISNUM(2)) )
   {
      * ((unsigned int *) &byteptr)     = _parni(2);
      * ((unsigned int *) &byteptr + 1) = _parni(1);
	  pmptr = ExoProtectedPtr(byteptr, 8);
	  _retni( (unsigned int) (*pmptr) );
    ExoFreeSelector(* ((unsigned int *) &pmptr + 1));
   }
   else
      _retni( -1 );
   return;
}
