/*
    John Agusta, December 14, 1991

    NU_TEST.PRG  Minimum code to test the NET_USE() function.
                 Run NU_TEST.EXE from any subdirectory and pass
                 it the name of a .dbf file.

    Compile instructions:

               clipper nu_test /n /w

    Link instructions:

               rtlink fi test

*/

#command IF_NETUSE <(db)>                                        ;
            [VIA <rdd>]                                          ;
            [ALIAS <a>]                                          ;
            [<new: NEW>]                                         ;
            [<ex: EXCLUSIVE>]                                    ;
            [<sh: SHARED>]                                       ;
            [<ro: READONLY>]                                     ;
            [WAIT <wait>]                                        ;
            [INDEX <(index1)> [, <(indexn)>]]                    ;
                                                                 ;
   => if net_use(  <.new.>, <rdd>, <(db)>, <(a)>,                ;
                   if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),         ;
                      <.ro.>, <wait>, {<(index1)> [, <(indexn)>]})

#command IF_!NETUSE <(db)>                                       ;
            [VIA <rdd>]                                          ;
            [ALIAS <a>]                                          ;
            [<new: NEW>]                                         ;
            [<ex: EXCLUSIVE>]                                    ;
            [<sh: SHARED>]                                       ;
            [<ro: READONLY>]                                     ;
            [WAIT <wait>]                                        ;
            [INDEX <(index1)> [, <(indexn)>]]                    ;
                                                                 ;
   => if !net_use(  <.new.>, <rdd>, <(db)>, <(a)>,               ;
                   if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),         ;
                      <.ro.>, <wait>, {<(index1)> [, <(indexn)>]})


Function Main(cName)

Clear Screen

If cName == NIL .or. !(File(cName) .or. File(cName + '.dbf'))
   ? 'SYNTAX:  NU_TEST <FileName.dbf>'
   Quit
Endif

IF_NETUSE (cName) NEW SHARED WAIT 5
   ? "file is open and ready for use"
Else
   ? "file is not available"
Endif

? 'ALIAS:', Alias()

RETURN NIL

/*
 Ŀ
ݳ   Function......: Net_Use()                                              
ݳĳ
ݳ   Programmer....: John Agusta                                            
ݳ   Date..........: December 13, 1991                                      
ݳ   Notes.........: Tries to open a file while checking for NetErr().      
ݳ   Pass the same first six parameters used by the DBUSEAREA() function    
ݳ   along with an optional numeric seventh parameter specifying the number 
ݳ   of seconds to wait before a failed return (this value defaults to zero 
ݳ   if omitted).  An optional eighth parameter type string array may       
ݳ   be passed as a list of indexes to be opened.                           
ݳ                                                                          
ݳ   Example:                                                               
ݳ     IF NET_USE( , , "Account", , .T., , 5)                               
ݳ        ? "Account file not available"                                    
ݳ     ENDIF                                                                
ݳ                                                                          
ݳ   Parameters....: lNewArea       LOGICAL                                 
ݳ                      Use new work area                                   
ݳ                   cDriver        CHARACTER                               
ݳ                      Database driver to be used                          
ݳ                   cName          CHARACTER                               
ݳ                      Filename to be opened                               
ݳ                   cAlias         CHARACTER                               
ݳ                      Alias to be used                                    
ݳ                   lShared        LOGICAL                                 
ݳ                      Open database in SHARED mode                        
ݳ                   lReadOnly      LOGICAL                                 
ݳ                      Open database in READONLY mode                      
ݳ                   nWait          NUMERIC                                 
ݳ                      Number of seconds to attempt open                   
ݳ                   acFile         ARRAY                                   
ݳ                      Character array containing list of indexes to open  
ݳ                                                                          
 

*/
FUNCTION NET_USE(lNewArea, cDriver, cName, cAlias, lShared, lReadOnly, nWait, acFile)
LOCAL lForever

// You can use "DEFAULT nWait to 0" if you use that definition
nWait := If(nWait == NIL, 0, nWait)
lForever := (nWait == 0)

DO WHILE (lForever .OR. nWait > 0)

   dbUseArea( lNewArea, (cDriver), (cName), (cAlias), lShared, lReadOnly)

   IF .NOT. NETERR()           // USE succeeds
      If ValType(acFile) == 'A'
         aeval(acFile, { | element | dbSetIndex(element) } )
      Endif
      RETURN (.T.)
   ENDIF
   
   INKEY(1)                   // wait 1 second
   nWait--
ENDDO
RETURN (.F.)             // USE fails
* End - NET_USE
