/*
 * File......: WRITPROP.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_WrProVa()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Write Property Value
 *  $SYNTAX$
 *
 *     FN_WrProVa(cOwnerName, nOwnerType, cProperty, cNewValue) => cOldValue
 *
 *  $ARGUMENTS$
 *
 *     <cOwnerName> is the name of the Bindery Object that owns the
 *	   Property you are trying to change. Max Len = 47
 *
 *     <nOwnerType> is <cOwnerName>'s Object Type.  Manifest constants
 *	   describing the defined types are included in the NETTO.CH
 *	   header file.
 *
 *     <cProperty> is the string containing the name of the property
 *	   whose value you want to change.  The property must be of
 *	   type item. Max Len = 15
 *
 *     <cNewValue> is a string containing the new value that you want stored
 *	   for that property. Max Len = 32,640.  Suggested Max = 128.
 *
 *  $RETURNS$
 *
 *     <cOldValue> returns the previous value of the Property if it
 *	      was an Item Property.  Note that fn_Error() must be
 *	      checked to determine if it was successful.  If not,
 *	      consider checking to see if the fn_rdProVal() still
 *	      matches the cOldValue returned here.  If a multi-segment
 *	      update failed in the middle, who knows what value the
 *	      property might now have.
 *
 *	      The function returns NIL, and sets an error code if
 *	      the property you attempted to update is a SET.
 *
 *  $DESCRIPTION$
 *
 *     This function changes the value of a property of type ITEM.
 *
 *     Changes to a SET item should use fn_adBndO() or fn_dBndOSe()
 *
 *     The maximum size of the property value is 255 segments of 128
 *     bytes each (32,640).  You should try to keep the values less
 *     than 128 bytes for performance.
 *
 *  $SEEALSO$
 *     fn_rdProVa() fn_adBndO() fn_dBndOSe()
 *  $EXAMPLES$
 *
 *     cOld := FN_WrProVa("LARRY", OT_USER, "IDENTIFICATION" , "Larry H.")
 *     IF fn_Error() == ESUCCESS
 *	  Qout("User LARRY's Full Name changed from ")
 *	  QQout(cOld)
 *	  QQout(" to Larry H.")
 *     ELSE
 *	  Qout("Error:",fn_Error())
 *     ENDIF
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG     227

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProperty, cValue)
    LOCAL cOld := FN_WrProVa(cObject, Val(nType), cProperty, cValue)
    IF fn_Error() == ESUCCESS
      QOut(cValue," replaced ", cOld)
    ELSE
      QOut("Error:",fn_Error())
    ENDIF

  RETURN ( nil )
#endif

FUNCTION FN_WrProVa(cOwner, nType, cProperty, cValue)
  LOCAL nSegment  := 1
  LOCAL cRetVal   := NIL
  LOCAL cSend
  LOCAL aOldValue

  ////////  First part of request packet doesn't change
  LOCAL cStart := I2BYTE(62);		  // 3Eh  API request code
		+ W2HILO(nType);	  // nw_int Object type of Owner
		+ FN_NameL(cOwner,48);	  // Owner's Name

  // See  crtprop.prg for Upper(cProperty) discussion
  cProperty := Upper(cProperty)

  ////////  See what's in the property now, and test for ITEM type
  aOldValue := fn_ScaProp(cOwner, nType, cProperty)


  IF !aOldValue == nil .AND. aOldValue[1,6]   // was there an old value?
    cRetVal := aOldValue[1,7]	  // If so, save the old value
  ENDIF

  DO WHILE fn_Error() == ESUCCESS .AND. Len(cValue) > 128
     cSend := cStart;
	    + Chr(nSegment++);	      // segment number being stored
	    + Chr(255); 	      // indicates more segments to come
	    + FN_NameL(cProperty,16); // Property Name
	    + Left(cValue, 128)       // This segments value


     _fnReq(NW_LOG,cSend,"") // Go do it
     cValue := Substr(cValue,129)      // Remove segment just sent
  ENDDO

  IF fn_Error() == ESUCCESS
    cSend := cStart;
	   + Chr(nSegment++);	     // segment number being stored
	   + Chr(0);		     // indicates FINAL segments
	   + FN_NameL(cProperty,16); // Property Name
	   + PadR(cValue,128,Chr(0)) // This segments value, padded to 128

    _fnReq(NW_LOG,cSend,"") // Go do it
  ENDIF

RETURN cRetVal
