/*
 * File......: FINSVC.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_finSQJb()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Finish servicing queue job and file 
 *  $SYNTAX$
 *
 *     fn_finSQJb( <nQueueID>, <nJob>, <nHandle> [, <nCharge> ] ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number the server is finished with
 *     <nHandle>  is the DOS file handle returned from fn_sQJobFi()
 *     <nCharge>  is for charge accounting and is not used in the QMS
 *                implementation as of NetWare 3.11.  This allows for
 *                telling the accounting system how much the job cost.
 *
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *  $DESCRIPTION$
 *
 *     Only a queue server that has previously obtained a job for 
 *     service can make this call.
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_finSQJb( nQueueID, nJob, nHandle, nCharge )
  local cReq, cRep, lRes := .f.

  default nCharge to 0

  if pcount() >= 3 .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nHandle  ) == "N" .and. ;
     valtype( nJob     ) == "N" .and. ;
     valtype( nCharge  ) == "N"

     if ( nHandle # -1 ) 
        fclose( nHandle )
     endif

     cReq := I2BYTE( 114  ) + L2HILO( nQueueID ) + ;
             W2HILO( nJob ) + L2HILO( nCharge )
     cRep := ""
     
     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )

  else
     _fnSetErr( EBADPARM )
  endif

  return lRes



