/*
 * File......: SETDH.PRG
 * Author....: David Minter
 * CIS ID....: 
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by [] and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     fn_setDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Set directory handle
 *  $SYNTAX$
 *
 *     fn_setDH( nhSrc, cSrcPath, nhTarg ) -> nRes
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_setDH( nhSrc, cSrcPath, nhTarg )
  local cReq, cRep, nRes := -1

  if pcount() == 3 .and. valtype( nhSrc ) == "N" .and. ; 
     valtype( cSrcPath ) == "C" .and. valtype( nhTarg ) == "N"

     cReq := I2BYTE( 0 )     + I2BYTE( nhTarg )         + ;
             I2BYTE( nhSrc ) + I2BYTE( len( cSrcPath )) + ;
             cSrcPath
     cRep := ""

     nRes :=  _fnReq( 226, cReq, @cRep )
  else
    _fnSetErr( EBADPARM )
  endif

  return nRes
