/*
 * File......: NETVER.PRG
 * Author....: Joe Booth
 * CIS ID....: 
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Joe Booth and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_NETVER()
 *  $CATEGORY$
 *      File Server
 *  $ONELINER$
 *      Return the Netware version as a numeric
 *  $SYNTAX$
 *
 *      fn_NetVer() -> nVersion
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      A number contain the version number of Netware. The integer
 *      portion is the major number and the decimal is the minor
 *      version number.
 *
 *      Returns 0.0 if not logged in.
 *
 *
 *  $DESCRIPTION$
 *
 *      This function is used to determine the Netware version if you
 *      have version specific requirements in your application.
 *     
 *  $EXAMPLES$
 *
 *      LOCAL nServerId := FN_DefCid()
 *      LOCAL nQueue
 *      if fn_netver() > 2.0                // Link capture to PRINTQ_0
 *         nQueue := FN_gBndOID("PRINTQ_0", OT_PRINT_QUEUE)
 *         fn_Scappq(1,nServerId,nQueue)
 *      endif
 *      fn_sLPTCap()
 *
 *  $SEEALSO$
 *      fn_getFsi() fn_is3x()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_netVer()
   local nVersion := 0.0
   local arr_     := fn_getFsi()

   if !empty(arr_)
      nVersion := arr_[2]+(arr_[3]/100)
   endif

   return nVersion
