#include "extend.h"
#include "string.h"

int AsmLoginToFileServer           ( char*, int, char* );
int AsmVerifyBinderyObjectPassword ( char*, int, char* );
int AsmChangeBinderyObjectPassword ( char*, int, char*, char* );

/*  $DOC$
 *  $FUNCNAME$
 *      _fnLogFS3()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      LogIntoFileServer (encrypted bindery)
 *  $SYNTAX$
 *
 *      _fnLogFS3( cObjName, nObjType, cObjPassword ) -> nReturnCode
 *
 *  $ARGUMENTS$
 *
 *      cObjName is a C far pointer to a string containing the Object's
 *      name.  The string must be in all Caps.
 *
 *      nObjType is a C INT representing the Object's type.
 *
 *      cObjPassword is a C far pointer to a string containing the Object's
 *      password, if any.  The string must be in all Caps.
 *
 *  $RETURNS$
 *
 *      An INT representing the result of the operation.
 *
 *  $DESCRIPTION$
 *
 *      This function is used internally by fn_loginFS() to call
 *      _AsmLoginToFileServer(), if encryption is enabled.  The
 *      default release of Netto does not support password 
 *      encryption.  See elsewhere in the Norton Guide for
 *      more details on password encryption support.
 *
 *  $SEEALSO$
 *      fn_loginFS()
 *  $INCLUDE$
 *
 *  $END$
 */

CLIPPER _fnLogFS3 ( void )
{
    _retni( AsmLoginToFileServer( _parc(1), _parni(2), _parc(3) ) );
}

/*  $DOC$
 *  $FUNCNAME$
 *      _fnVerPW3()
 *  $CATEGORY$
 *      Bindery
 *  $ONELINER$
 *      VerifyBinderyObjectPassword (encrypted bindery)
 *  $SYNTAX$
 *
 *      _fnVerPW3( cObjName, nObjType, cObjPassword ) -> nReturnCode
 *
 *  $ARGUMENTS$
 *
 *      cObjName is a C far pointer to a string containing the Object's
 *      name.  The string must be in all Caps.
 *
 *      nObjType is a C INT representing the Object's type.
 *
 *      cObjPassword is a C far pointer to a string containing the Object's
 *      password, if any.  The string must be in all Caps.
 *
 *  $RETURNS$
 *
 *      An INT representing the result of the operation.
 *
 *  $DESCRIPTION$
 *
 *      This function is used internally by fn_?????() to call
 *      _AsmVerifyBinderyObjectPassword(), if encryption is enabled.
 *      The default release of Netto does not support password 
 *      encryption.  See elsewhere in the Norton Guide for
 *      more details on password encryption support.

 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

CLIPPER _fnVerPW3 ( void )
{
    _retni( AsmVerifyBinderyObjectPassword( _parc(1), _parni(2),
 				_parc(3) ) );
}

/*  $DOC$
 *  $FUNCNAME$
 *      _fnChgPW3()
 *  $CATEGORY$
 *      Bindery
 *  $ONELINER$
 *      ChangeBinderyObjectPassword (encrypted bindery)
 *  $SYNTAX$
 *
 *      _fnChgPW3( cObjName, nObjType, cOldObjPassword, ;
 *                                     cNewObjPassword  ) -> nReturnCode
 *
 *  $ARGUMENTS$
 *
 *      cObjName is a C far pointer to a string containing the Object's
 *      name.  The string must be in all Caps.
 *
 *      nObjType is a C INT representing the Object's type.
 *
 *      cOldObjPassword is a C far pointer to a string containing the
 *      Object's existing password, if any.  The string must be in all Caps.
 *
 *      cNewObjPassword is a C far pointer to a string containing the
 *      Object's new password, if any.  The string must be in all Caps.
 *
 *  $RETURNS$
 *
 *      An INT representing the result of the operation.
 *
 *  $DESCRIPTION$
 *
 *      This function is used internally by fn_?????() to call
 *      _AsmChangeBinderyObjectPassword(), if encryption is enabled.
 *      The default release of Netto does not support password 
 *      encryption.  See elsewhere in the Norton Guide for
 *      more details on password encryption support.
 *
 *  $SEEALSO$
 * 
 *  $INCLUDE$
 *
 *  $END$
 */

CLIPPER _fnChgPW3 ( void )
{
    _retni( AsmChangeBinderyObjectPassword( _parc(1), _parni(2),
 				_parc(3), _parc(4) ) );
}

