#include "ftint86.ch"

#define REQ_ADDR 31264  // 7A20H
#define INT2F	    47  // 2FH

static lIsVLM  :=  .f.
static lIsInit :=  .f.
static nAddr   :=   0

init procedure _fnReqInit
   local aRegs[ INT86_MAX_REGS ]

   aRegs[ AX ] := REQ_ADDR
   aRegs[ BX ] := 0

   if ft_int86( INT2F, aRegs )
      lIsInit := .t.
      lIsVLM  := ( aRegs[ AX ] == 0 )

      if lIsVLM
         // Far address of requestor is in ES:BX; set it here
      endif
   endif

   return

function _fnIsVLM()
   return lIsInit

function _fnIsReqInit()
   return lIsInit	   