/*
 * File......: ISINSET.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_bndOInS()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Is Bindery Object In Set
 *  $SYNTAX$
 *
 *     FN_bndOInS(cOwnerName, nOwnerType, cProperty, cMemberName, nMemberType  )
 *	       => lIsInSet
 *
 *  $ARGUMENTS$
 *
 *     <cOwnerName> is the name of the Bindery Object that owns the SET
 *		 property you are going to search.  Max Length = 47
 *
 *     <nOwnerType> is the Object Type for <cOwnerName>.  Manifest constants
 *	       describing the defined types are included in the NETTO.CH
 *	       header file.
 *
 *     <cProperty> is the string containing the name of the <cOwnerName>'s
 *	       SET property that you wan to search.  Max Length = 15
 *
 *     <cMemberName> Bindery Object Name that you want to find in the
 *	       <cProperty>  SET.   Max Length = 47
 *
 *     <nMemberType> is the Object Type for <cMemberName>.  Manifest
 *		     constants describing the defined types are included 
 *		     in the NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     <lIsInSet> Logical if cMemberName is included in the SET property.
 *
 *  $DESCRIPTION$
 *
 *     This function determines if a bindery object is a member
 *     of a SET property.  If the object is not in the set,
 *     or an error occurs, false is returned.
 *
 *  $EXAMPLES$
 *
 *	 // This example determines if Group EVERYONE is
 *	 // one of STEVE's  GROUPS_I'M_IN set members
 *
 *	 lInSet := FN_bndOInS("STEVE"    ,OT_USER        ,"GROUPS_I'M_IN";
 *			     ,"EVERYONE" ,OT_USER_GROUP)
 *
 *  $SEEALSO$
 *	 fn_adBndO() fn_dBndOSe()
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#define NW_LOG 227

#ifdef FT_TEST

  FUNCTION MAIN(cOwner, nOwnerType, cProperty, cMemberName, nMemberType)
  LOCAL lInSet
    DEFAULT cOwner	 TO "EVERYONE"
    DEFAULT nOwnerType	 TO  "2"   //  OT_USER_GROUP
    DEFAULT cProperty	 TO  "GROUP_MEMBERS"
    DEFAULT cMemberName  TO  "SUPERVISOR"
    DEFAULT nMemberType  TO  "1"   //  OT_USER
    Qout("Owner       Type     Property     Member    Type")
    Qout(cOwner, nOwnerType, cProperty, cMemberName, nMemberType)
    IF FN_bndOInS(cOwner, Val(nOwnerType), cProperty, cMemberName, Val(nMemberType))
      QQout("Found")
    ELSE
      QQout("Error:", fn_error())
    ENDIF
  RETURN ( nil )

#endif


FUNCTION FN_bndOInS(cOwner, nOwnerType, cProperty, cMemberObject, nMemberType)

  LOCAL cSend := I2BYTE(67);		    // 43h  API request code
	       + W2HILO(nOwnerType);	    // nw_int Object type
	       + fn_NameL(cOwner,48);	    // Property Owner Object Name
	       + fn_NameL(cProperty,16);    // Property Name
	       + W2HILO(nMemberType);	    // nw_int Member Object type
	       + fn_NameL(cMemberObject,48) // Object to search for

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS

