/*
 *   File......: GSOFDL.Prg
 *   Author....: Sheldon Easterbrook
 *   CIS ID....: 71421,254
 *   Date......: $Date$
 *   Revision..: $Revision$
 *   Log File..: $LogFile$
 *
 *   This is an original work by Sheldon Easterbrook and is placed in the
 *   Public Domain
 *
 *   Modification History:
 *   ---------------------
 *
 *   $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     Fn_GSPFDL()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the search order of a drive letter
 *  $SYNTAX$
 *
 *      Fn_GSOFDL( <cPathVar>,<cDrvLtr> ) -> nSearchOrder
 *
 *  $ARGUMENTS$
 *
 *      <cPathVar> - The path string to search.
 *
 *      <cDrvLtr>  - The drive letter to search for.
 *
 *  $RETURNS$
 *
 *     <nSearchOrder> - The current search order for <cDrvLtr> in
 *                      <cPathVar>.
 *
 *  $DESCRIPTION$
 *
 *      This function searches the specified path variable for
 *      the specified drive letter and returns the search order
 *      of that drive letter.  If the drive is not in the path
 *      <nSearchOrder> will be 0.
 *
 *  $EXAMPLES$
 *      If ( Fn_GSOFDL( GetEnv( "PATH" ),"Y" ) == 0 )
 *          ? "Drive Y: isn't in the search path.  Good to know, eh?"
 *      EndIf
 *  $SEEALSO$
 *      Fn_GDLFSO()
 *  $INCLUDE$
 *
 *  $END$
 */

function Fn_GSOFDL( cPathVar,cDrvLtr )
    Local nSrchOdr := 0
    Local cTemp    := ""
    Local nI       := 1

    If ( Empty( cPathVar ))
        Return( 0 )
    EndIf

    cTemp := cPathVar

    Do While (  !Empty( cPathVar ) .and. ;
                (;
                   ( SubStr( cPathVar,2,1 ) != ":"     )   .or. ;
                   ( SubStr( cPathVar,1,1 ) != cDrvLtr )        ;
                );
              )
        cPathVar := SubStr( cPathVar,At( ";",cPathVar ))
        If ( !Empty( cPathVar ))
            cPathVar := SubStr( cPathVar,2 )
            nSrchOdr++
        EndIf
    EndDo

    If ( nSrchOdr > 0 )
        nSrchOdr++
    EndIf

    If (( cPathVar == cTemp ) .and. ( nSrchOdr == 0 ))
        nSrchOdr++
    EndIf

   Return( Iif( Empty( cPathVar ),0,nSrchOdr ))
