/*
 * File......: GETNAME.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_BndONam()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Get Bindery Object Name
 *  $SYNTAX$
 *
 *     FN_BndONam(nId, [@nType]) => cObjName
 *
 *  $ARGUMENTS$
 *
 *     <nId> is the object ID you want to look up. It must  be
 *     expressed as an integer.
 *
 *     [@<nType>] is an optional parameter that should be passed by
 *     reference.  It will be set to the Bindery Object Type.  Manifest
 *     constants describing the defined types are included in the
 *     NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     <cObjName>, the name of the object that corresponds with the id
 *     number.  If <cObjName> is empty, an error occured.  Check
 *     fn_error().
 *
 *  $DESCRIPTION$
 *
 *     This function returns the object name and type for the passed Bindery
 *     object id number.
 *
 *  $SEEALSO$
 *     fn_gBndOId()
 *  $EXAMPLES$
 *
 *      nId := Fn_gbndOId("STEVE", OT_USER)
 *      IF fn_error() == 0
 *         cName := FN_BndONam(nId, @nType)
 *         Qout(cName,nType)     // result: STEVE 1
 *      ENDIF
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION Main(nId)
  LOCAL nType
  LOCAL cName
    nId := Val(nId)
    cName := FN_BndONam(nId,@nType)
    QOut(nId,cName,nType)
  RETURN ( nil )

#endif

FUNCTION FN_BndONam(nId, nType)
LOCAL cReceive := Space(54)
LOCAL cRetVal  := ""

  IF ValType(nId) == "N"
    nId := L2HILO(nId)
    //36h  API request code
    IF _fnReq(NW_LOG, Chr(54)+nId, @cReceive) == ESUCCESS
      nType   := HILO2W(Substr(cReceive, 5, 2))  // return object type
      cRetVal := fn_NoNull(Substr(cReceive, 7))  // name of object
    ELSE
      nType   := OT_UNKNOWN     // on error, object type is unknown
    ENDIF
  ELSE
    _fnseterr( EBADPARM )
  ENDIF

RETURN (cRetVal)
