/*
 * File......: GETFSI.PRG
 * Author....: Rodgers Moore
 * CIS ID....: 75730,2244
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Rodgers Moore and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_GETFSI()
 *  $CATEGORY$
 *      File Server
 *  $ONELINER$
 *      Get default File Server Information
 *  $SYNTAX$
 *
 *      fn_GetFSI() -> aFS_Info
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      An array of 17 elements containing the information about
 *      the default File Server.
 *
 *        aFS_Info[1]   contains the File Server Name.
 *        aFS_Info[2]   contains the Netware Major version number.
 *        aFS_Info[3]   contains the Netware Minor version number.
 *        aFS_Info[4]   contains the Max connections supported by server.
 *        aFS_Info[5]   contains the connections currently in use.
 *        aFS_Info[6]   contains the Max connected volumes.
 *        aFS_Info[7]   contains the OS Revision Number.
 *        aFS_Info[8]   contains the SFT Level.
 *        aFS_Info[9]   contains the TTS Level.
 *        aFS_Info[10]  contains the Peak connections used.
 *        aFS_Info[11]  contains the Accounting Version.
 *        aFS_Info[12]  contains the VAP Version.
 *        aFS_Info[13]  contains the Queuing Version.
 *        aFS_Info[14]  contains the Print Server Version.
 *        aFS_Info[15]  contains the Virtual Console Version.
 *        aFS_Info[16]  contains the Security Restrictions Level.
 *        aFS_Info[17]  contains the Internetwork Bridge Version.
 *
 *      Returns an empty array if not logged in.
 *
 *
 *  $DESCRIPTION$
 *
 *      This function implements the File Server API call GET FILE SERVER
 *      INFORMATION.  Returns an array of 17 items of information.
 *     
 *  $EXAMPLES$
 *
 *      qout( "File Server Name is: " + fn_GetFSI()[1] )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_GetFSI()
   local cReq, cRep, aReply 

   cReq   := I2BYTE( 17 )
   cRep   := space(130)
   aReply := {}

   if _fnReq( 227, cReq, @cRep ) == ESUCCESS
     aadd( aReply, substr( cRep,1,48))
     aadd( aReply, BYTE2I(substr( cRep,49,1)))
     aadd( aReply, BYTE2I(substr( cRep,50,1)))
     aadd( aReply, HILO2W(substr( cRep,51,2)))
     aadd( aReply, HILO2W(substr( cRep,53,2)))
     aadd( aReply, HILO2W(substr( cRep,55,2)))
     aadd( aReply, BYTE2I(substr( cRep,57,1)))
     aadd( aReply, BYTE2I(substr( cRep,58,1)))
     aadd( aReply, BYTE2I(substr( cRep,59,1)))
     aadd( aReply, HILO2W(substr( cRep,60,2)))
     aadd( aReply, BYTE2I(substr( cRep,62,1)))
     aadd( aReply, BYTE2I(substr( cRep,63,1)))
     aadd( aReply, BYTE2I(substr( cRep,64,1)))
     aadd( aReply, BYTE2I(substr( cRep,65,1)))
     aadd( aReply, BYTE2I(substr( cRep,66,1)))
     aadd( aReply, BYTE2I(substr( cRep,67,1)))
     aadd( aReply, BYTE2I(substr( cRep,68,1)))
   endif

   return ( aReply )
