/*
 * File......: FSDTIME.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     FN_GFSDTIM()
 *  $CATEGORY$
 *     File Server
 *  $ONELINER$
 *     Get Netware file server date and time
 *  $SYNTAX$
 *
 *     fn_gFSdTim() -> { dDate, cTime } 
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     A two element array.  The first element is the current file 
 *     server date, and the second element is the current file 
 *     server time.
 *
 *     If anything goes wrong with the function, you'll simply get
 *     a null date and an empty string for the time.
 *
 *  $DESCRIPTION$
 *
 *     This call obtains the current file server date and time.
 *
 *     This function can be used to synchronize workstation 
 *     clocks to the file server time.  This can be used as a 
 *     security measure if some program depends on the current
 *     time.
 *     
 *  $EXAMPLES$
 *
 *     /*  Here is a replacement for the Netware utility SYSTIME,
 *         written in Clipper.  Note that SYSTIME updates the 
 *         current workstation date and time, as well as tells you
 *         what the default file server's date and time is.
 *         Requires NANFOR.LIB, of course.
 *     */
 *
 *     function systime()
 *         local aRes
 *      
 *         aRes := fn_gFSdTim()
 *         if !empty( aRes[1] ) .and. !empty( aRes[2] )
 *            ft_setdate( aRes[1] )
 *            ft_settime( aRes[2] )
 *            qout( cdow(   aRes[1] )      + ", " + ;
 *                  cMonth( aRes[1] )      + " "  + ;
 *                  str(  day( aRes[1] ) ) + ", " + ;
 *                  str( year( aRes[1] ) ) " "  " + ;
 *                  aRes[2]                         ;
 *                )
 *         endif
 *         return nil
 *         
 *
 *
 *  $END$
 */

function fn_gFSdTim()
  local aRegs[ INT86_MAX_REGS ], cRepPkt, dDate, cTime

  dDate        := ctod( '' )
  cTime        := ""
  cRepPkt      := repl( chr(0), 7 )
  aRegs[AX]    := makehi( 231 )
  aRegs[DS]    := cRepPkt
  aRegs[DX]    := REG_DS

  if ft_int86( INT21, aRegs )

     dDate := _fnnctod( substr( aRegs[DS], 1, 3 ) )
     cTime := _fnnctot( substr( aRegs[DS], 4, 3 ) )

  else
     _fnseterr( EINT86 )
  endif

  return { dDate, cTime }

  
