; File......: FNNEG.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_NEG()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Calculate the two's complement of a number
; $SYNTAX$
;    fn_neg( <nInt> | <cInt> ) -> nResult
; $ARGUMENTS$
;
;    <nInt> may either be a numeric integer, or a 16-bit character string
;    that is the binary representation of a numeric integer.
;
; $RETURNS$
;
;    <nResult>, a numeric
;
; $DESCRIPTION$
;
;     The value returned is obtained by negating <nInt>
;     (i.e. obtaining the two's complement). If any parameters
;     are invalid, the function will return zero.
;
; $EXAMPLES$
;
;     nX := 1
;     nNum := fn_neg( nX )
;     ? nNum    //  -1
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;


IDEAL

PUBLIC   FN_NEG

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_NEG       FAR

         MOV       AX,5EF7h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_NEG
ENDS     _FNNET
END
