; File......: FNAND.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
; Date......: $Date$
; Revision..: $Revision$
; Log file..: $Logfile$
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log$
;

; $DOC$
; $FUNCNAME$
;    FN_AND()
; $CATEGORY$
;    Miscellaneous
; $ONELINER$
;    Perform a bitwise AND
; $SYNTAX$
;    fn_and( <nInt1>, <nInt2> ) -> nResult
; $ARGUMENTS$
;
;    <nInt1>  may either be a numeric integer, or a 16-bit character string
;    that is the binary representation of a numeric integer.  
;
;    <nInt2>  must be a numeric integer.
;
; $RETURNS$
; 
;  <nResult>, a numeric.
; 
; $DESCRIPTION$
;
;  The value returned is obtained by performing
;  a bitwise AND with Int1 and Int2 as operands.
;  If any parameters are invalid, the function
;  will return zero.
;
; $EXAMPLES$
;
;       nX := 11
;       nNum := fn_and( nX, 12 )
;       ? nNum          // 8
;
; $SEEALSO$
;
; $INCLUDE$
;
; $END$
;
;

IDEAL

PUBLIC   FN_AND

EXTRN    __FNCBALL:FAR

SEGMENT  _FNNET  WORD      PUBLIC    "CODE"
         ASSUME    CS:_FNNET

PROC     FN_AND       FAR

         MOV       AX,4621h
         MOV       DX,0CBFAh
         JMP       __FNCBALL

ENDP     FN_AND
ENDS     _FNNET
END

