/*
 * File......: ENV.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227


/*  $DOC$
 *  $FUNCNAME$
 *      fn_wkstEnv()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetWorkstationEnvironment
 *  $SYNTAX$
 *
 *      fn_wkstEnv() -> aShellEnvironment
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      An array containing the following information about the workstation
 *      shell environment:
 *
 *               Position   Description              Example
 *               
 *                  1       Operating System         "MSDOS"
 *                  2       OS Version               "3.30"
 *                  3       Long Hardware Type       "IBM_PC"
 *                  4       Short Hardware Type      "IBM"
 *
 *  $DESCRIPTION$
 *
 *      This function returns information about the NetWare shell at the
 *      current workstation, however it does not query the workstation or
 *      hardware to verify what type it is.  Thus there is no guarantee 
 *      that the information returned is correct.
 *
 *      The shell constructs the above information from the DOS version
 *      running on the workstation plus the contents of SHELL.CFG, if
 *      present.
 *
 *  $EXAMPLES$
 *
 *      IF fn_wkstEnv()[ 3 ] == "COMPAQ"
 *         QOUT( "Insert your Compaq setup diskette in drive A:" )
 *         WAIT
 *      ENDIF
 *
 *  $SEEALSO$
 *      fn_connInf()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_wkstEnv()
	LOCAL cRepBuffer := REPLICATE( I2BYTE( 0 ) , 40 )
	LOCAL aReply[ 4 ], j, i := 1
	LOCAL aRegs[ INT86_MAX_REGS ]
	AFILL( aReply, "" )

	aRegs[ AX ] := ft_HEX2DEC( "EA01" )   // Netware Service EAh, Function 01
	aRegs[ BX ] := 0
	aRegs[ ES ] := cRepBuffer	           // point to reply buffer
	aRegs[ DI ] := REG_ES

	IF !ft_int86( INT21, aRegs )          // call Netware
		_fnSetErr( EINT86 )
	ENDIF

	/* fill array with strings containing shell info */

	cRepBuffer  := aRegs[ ES ]

	FOR j := 1 TO 4
		aReply[ j ] := SUBSTR( cRepBuffer, 1, ( i := AT( I2BYTE( 0 ), cRepBuffer ) ) - 1 )
		cRepBuffer  := SUBSTR( cRepBuffer, ++i )
	NEXT

RETURN( aReply )
