/*
 * File......: DELPROP.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_delProp()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Delete Property
 *  $SYNTAX$
 *
 *     FN_delProp(cObjectName, nObjectType, cProperty) => lDeleted
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *		     trying to delete a property for.  Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *     <cProperty> is the name of the property you want to delete.
 *		   Max Length = 15
 *
 *  $RETURNS$
 *
 *     <lDeleted> if property was deleted.
 *
 *  $DESCRIPTION$
 *
 *     This function deletes a bindery objects property.
 *
 *  $SEEALSO$
 *    fn_creProp() fn_delBndO
 *  $EXAMPLES$
 *
 *     // this will delete the property IDENDTIFICATION from user KEVIN
 *     lDeleted := FN_delProp("KEVIN", OT_USER, "IDENTIFICATION")
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]
#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProperty)
    DEFAULT cObject    TO "TESTUSER"
    DEFAULT nType      TO "1" // OT_USER
    DEFAULT cProperty  TO "GROUPS_I'M_IN"
    IF FN_delProp(cObject, Val(nType), cProperty)
      Qout("Property has been deleted.")
    ELSE
      Qout("Property has not been deleted.")
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_delProp(cObject, nType, cProperty)

  LOCAL cSend := I2BYTE(58);		  // 3Ah API Request Code
	       + W2HILO(nType); 	  // nw_int Object type
	       + fn_NameL(cObject,48);	  // Owner Name
	       + fn_NameL(Upper(cProperty),16)	 // Property Name

    // See  crtprop.prg for Upper(cProperty) discussion
               
RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
