/*
 * File......: DELOBJS.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_dBndOSe()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Delete Bindery Object From Set
 *  $SYNTAX$
 *
 *     FN_dBndOse(cOwnerName, nOwnerType, cProperty, cMemberName, nMemberType  )
 *	       => lDeleted
 *
 *  $ARGUMENTS$
 *
 *     <cOwnerName> is the name of the Bindery Object that owns the SET
 *		    property from which you will delete a member.
 *		    Max Length = 47
 *
 *     <nOwnerType> is the Object Type for <cOwnerName>.  Manifest constants
 *		    describing the defined types are included in the NETTO.CH
 *		    header file.
 *
 *     <cProperty> is the string containing the name of the <cOwnerName>'s
 *		   SET property.  Max Length = 15
 *
 *     <cMemberObject> Bindery Object Name that you will delete from cProperty.
 *		       Max Length = 47
 *
 *     <nMemberType> is the Object Type for <cMemberName>.  Manifest
 *		     constants describing the defined types are included 
 *		     in the NETTO.CH header file.
 *
 *  $RETURNS$
 *
 *     <lDeleted> if object was deleted from set.
 *
 *  $DESCRIPTION$
 *
 *     This function deletes an object from a Bindery objects property set.
 *
 *  $EXAMPLES$
 *
 *	 // This example deletes Group DEVELOPMENT from
 *	 // STEVE's  GROUPS_I'M_IN set
 *
 *	 lDeleted := FN_dBndOSe("STEVE"    ,OT_USER        ,"GROUPS_I'M_IN";
 *			       ,"DEVELOPMENT" ,OT_USER_GROUP)
 *
 *  $SEEALSO$
 *     fn_adBndO() fn_delBndO()
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]
#define NW_LOG 227

#ifdef FT_TEST

  FUNCTION MAIN(cOwnerName, nOwnerType, cProperty, cMemberObject, nMemberType)
    DEFAULT cOwnerName TO "TESTUSER"
    DEFAULT nOwnerType TO "1" // OT_USER
    DEFAULT cProperty  TO "GROUPS_I'M_IN"
    DEFAULT cMemberObject TO "TESTGROUP"
    DEFAULT nMemberType   TO "2" // OT_USER_GROUP
    IF FN_dBndOSe(cOwnerName, Val(nOwnerType), cProperty, cMemberObject, Val(nMemberType))
      Qout("Object has been deleted.")
    ELSE
      Qout("Object has not been deleted.")
    ENDIF
  RETURN ( nil )

#endif

FUNCTION FN_dBndOSe(cOwnerName, nOwnerType, cProperty, cMemberObject, nMemberType)

  LOCAL cSend := I2BYTE(66);		    // 42h API request code
		+W2HILO(nOwnerType);	    // nw_int Prop Owner Object type
		+FN_NameL(cOwnerName,48);   // Property Owner Object Name
		+FN_NameL(Upper(cProperty),16);    // Property Name
		+W2HILO(nMemberType);	    // nw_int Member Object type
		+FN_NameL(cMemberObject,48) // Member Object's Name

     // See  crtprop.prg for Upper(cProperty) discussion

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
