/*
 * File......: CURDIR.PRG
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "FTINT86.CH"
#include "netto.CH"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_GETCD()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the current directory
 *  $SYNTAX$
 *
 *     fn_GetCD( [<nDrive>] ) --> <cPathSpec>
 *
 *  $ARGUMENTS$
 *
 *    <nDrive> identifies the drive.  Use 0 for the default drive, 1 for
 *             drive A, 2 for drive B, and so on.  It is optional and
 *             if not passed the default drive will be used.
 *
 *  $RETURNS$
 *
 *    <cPathSpec> will be a path specification without a drive designator.
 *                If the call fails then an empty string will be returned
 *                and fn_Error() can be used to obtain error information.
 *
 *  $DESCRIPTION$
 *
 *    This call is virtually identical to Clipper's CurDir(), but is
 *    included here for the sake of completeness.
 *
 *  $EXAMPLES$
 *
 *    // Get the current directory of the default drive
 *
 *       ? fn_GetCD()
 *
 *    // Get current directory of drive C
 *
 *       ? fn_GetCD( 3 )
 *
 *  $SEEALSO$
 *    fn_MkDir fn_RmDir() fn_RenDir()
 *  $INCLUDE$
 *    netto.CH (only needed if you want to make use of the #defines for
 *              the error codes).
 *  $END$
 */

function fn_GetCD( nDrive )

  local aRegs[ INT86_MAX_REGS ]

  aRegs[ AX ] := makehi( 71 )
  aRegs[ DS ] := space( 128 )
  aRegs[ SI ] := REG_DS
  aRegs[ DX ] := iif( pcount() == 0, 0, nDrive )

  if FT_Int86( INT21, aRegs )
     if aRegs[ FLAGS ] % 2 == 0       // Check carry flag for error
        _fnSetErr( 0 )
        aRegs[ DS ] := left( aRegs[ DS ], at( chr( 0 ), aRegs[ DS ] ) - 1 )
     else
        _fnSetErr( UNSIGNED( lowbyte( aRegs[ AX ] ) ) )
     endif
  else
     _fnSetErr( EINT86 )
  endif

  return iif( fn_Error() == 0, "\" + aRegs[ DS ], "" )

