/*
 * File......: CRTPROP.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_creProp()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Create Property
 *  $SYNTAX$
 *
 *     FN_creProp(cObjectName, nObjectType, cProperty, lDynamic,
 *                lSet, nWrite, nRead)  => lCreated
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *                   trying to create a property for.
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.
 *
 *     <cProperty> is the name of the property you want to create.
 *		   The name can be up to 16 characters.
 *
 *     <lDynamic> if the new property will be dynamic or static. Set it
 *		  to true for dynamic and false for static.  Dynamic
 *        properties get deleted when the file server is initialized.
 *
 *     <lSet> if the new property will be a set or a item. Set it to
 *            true for a set and false for an item.
 *
 *     <nWrite> is the Property write security as an integer.
 *              The integer indicates who can change the property.
 *
 *     <nRead> is the Property read security as an integer.
 *	       The integer indicates who can read and scan
 *          for the property
 *
 *         Ŀ
 *          Read and Write Security Levels  
 *         Ĵ
 *          0 Anyone                       
 *         Ĵ
 *          1 Logged                       
 *         Ĵ
 *          2 Object                       
 *         Ĵ
 *          3 Supervisor                   
 *         Ĵ
 *          4 Netware Operating System     
 *         
 *
 *  $RETURNS$
 *
 *     <lCreated> logical if property was created.
 *
 *  $DESCRIPTION$
 *
 *     This function creates a property for a bindery object.
 *
 *  $SEEALSO$
 *     fn_delProp() fn_creBndO()
 *  $EXAMPLES$
 *
 *     lCreated :=  FN_creProp("KEVIN", OT_USER, "GROUPS_I'M_IN",;
 *                             .T., .F., 1, 1 )
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProperty, IsSet)
    DEFAULT cObject    TO "TESTUSER"
    DEFAULT nType      TO "1" // OT_USER
    DEFAULT cProperty  TO "GROUPS_I'M_IN"
    DEFAULT IsSet      TO "Y"

    IF FN_creProp(cObject, Val(nType), cProperty, .T., IsSet=="Y", 1, 1 )
      QOut("property has been created.")
    ELSE
      QOut("property has not been created.")
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_creProp(cObject, nType, cProperty, lDynamic, lSet, nWrite, nRead )

  LOCAL cSend := I2BYTE(57);			// 39h API Request Code
	       + W2HILO(nType); 		// nw_int Object type
	       + fn_NameL(cObject,48);		// Object Name
	       + I2BYTE(Iif(lDynamic, 1, 0);	// Set Dynamic/Static bit
		      + Iif(lSet, 2, 0));	// Set the ITEM/SET bit
	       + I2BYTE((nWrite * 16) + nRead); // Security Level
	       + fn_NameL(Upper(cProperty),16)	// Property Name

       // Note that property is converted to UPPER here for consistency.
       // Netware automatically creates the property name in upppercase,
       // but does not convert other calls that use propertyname to
       // to use uppercase.  i.e. if you try to write a property value,
       // you must specify the property name in uppercase.
       // These bindery functions will handle that upper() for the user,
       // and this UPPER is placed here to protect against possible future
       // changes by Novell.  If for some reason, they allow lower case
       // names in the future, this function would act differently than
       // the others.  Therefore it is safer to make this one work the
       // same as the others, and not rely on Novell keeping this
       // consistently inconsistent.

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
