/*
 * File......: CONNINF.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227


/*  $DOC$
 *  $FUNCNAME$
 *      fn_connInf()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetConnectionInformation
 *  $SYNTAX$
 *
 *      fn_connInf( [ <nConnectionNo> ] ) -> aConnectionInfo
 *
 *  $ARGUMENTS$
 *
 *      <nConnectionNo> is the connection number that you are interested in.
 *      If omitted, it defaults to the current workstation.
 *
 *  $RETURNS$
 *
 *      An array containing connection information according to the following
 *      table
 *
 *              Position       Description         Data Type
 *              
 *                 1           Object ID           Numeric
 *                 2           Object Type         Numeric
 *                 3           Object Name         Character
 *                 4           Login Date          Date
 *                 5           Login Day           Numeric (0-6)
 *                 6           Login Time          Character
 *
 *      For a list of Object Types, see the "Information" section
 *      of this Norton Guide.
 *
 *      If the returned Object ID is 0, there is no object logged into the
 *      requested connection number.  The Login Time is represented in 24
 *      hour format, i.e. HH:MM:SS.  The Login Date is represented as a
 *      Clipper date.
 *
 *  $DESCRIPTION$
 *
 *      This function returns information about the object currently logged
 *      in to the specified connection number.
 *
 *  $EXAMPLES$
 *
 *      aLogInfo := fn_connInf()
 *
 *      @ 10, 20 SAY 'Hello ' + TRIM( aLogInfo[ 3 ] ) + ;
 *                   ', your login time is ' + aLogInfo[ 6 ]
 *
 *  $SEEALSO$
 *      fn_whoami() fn_connNum() fn_connID()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_connInf( nConnNo )
	LOCAL cReqBuffer, cRepBuffer := REPLICATE( I2BYTE( 0 ) , 65 )
	LOCAL aReply := { 0, 0, '', CTOD('  /  /  '), 0, '' }, nRetVal := 0
   LOCAL aDT

	/* fetch default connection number if not specified */

	DEFAULT nConnNo TO fn_connNum()

	/* construct request packet */

	cReqBuffer := I2BYTE( ft_Hex2Dec( "16" ) ) +;
					  I2BYTE( nConnNo )

	/* call NetWare */

	_fnReq( E3h, cReqBuffer, @cRepBuffer )

	/* build return array */

    aDT := _fnStr2dt( subs( cRepBuffer, 55, 6 ) )

	aReply[ 1 ] := HILO2L( SUBSTR( cRepBuffer, 1,  4 ) )
	aReply[ 2 ] := HILO2W( SUBSTR( cRepBuffer, 5,  2 ) )
	aReply[ 3 ] := fn_NoNull(  SUBSTR( cRepBuffer, 7, 48 ) )
	aReply[ 4 ] := aDT[1]
	aReply[ 5 ] := BYTE2I( SUBSTR( cRepBuffer, 61, 1 ) )
	aReply[ 6 ] := aDT[2]

RETURN( aReply )
