/*
 * File......: CHGPSEC.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_cProSec()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Change Property Security
 *  $SYNTAX$
 *
 *     FN_cBndOse(cObject, nType, cProperty, nWrite, nRead) => lChanged
 *
 *  $ARGUMENTS$
 *
 *
 *     <cObjectName> is the name of the Bindery Object that you are trying
 *		     to change the property security for.  Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *		     describing the defined types are included in the
 *		     NETTO.CH header file.  Wildcard characters are
 *		     not allowed.
 *
 *     <cProperty> is the name of the property whose security is to be
 *		   changed.  Max Length = 15
 *
 *     <nWrite> is the Property write security as an integer.
 *		The integer indicates who can add properties
 *		to the bindery object.
 *
 *     <nRead> is the Property read security as an integer.
 *	       The integer indicates who can read and scan
 *	       properties for a bindery object.
 *
 *         Ŀ
 *          Read and Write Security Levels  
 *         Ĵ
 *          0 Anyone                       
 *         Ĵ
 *          1 Logged                       
 *         Ĵ
 *          2 Object                       
 *         Ĵ
 *          3 Supervisor                   
 *         Ĵ
 *          4 Netware Operating System     
 *         
 *
 *
 *  $RETURNS$
 *
 *     <lChanged> logical if security was changed or not.
 *	   If an error occurs, .F. will be the return value.
 *
 *  $DESCRIPTION$
 *
 *     This function changes the security of a bindery object's
 *     property.
 *
 *  $SEEALSO$
 *     fn_cBndOSe()
 *  $EXAMPLES$
 *
 *     // this will changes KEVIN's IDENTIFICATION property security
 *     // to SUPERVISOR to change and LOGGED to read
 *     lChanged := FN_cProSec("KEVIN", OT_USER, "IDENTIFICATION", 3, 1)
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProperty, nWrite, nRead)
    IF FN_cProSec(cObject, Val(nType), cProperty, Val(nWrite), Val(nRead))
      Qout("Property security was successfully changed.")
    ELSE
      Qout("Property security was not changed.")
    ENDIF
  RETURN ( nil )
#endif

FUNCTION FN_cProSec(cObject, nType, cProperty, nWrite, nRead )

  LOCAL cSend := I2BYTE(59);              // 3Bh API request code
	       + W2HILO(nType);                 // nw_int Object type
	       + FN_NameL(cObject,48);          // Owner Name
	       + I2BYTE((nWrite * 16) + nRead); // Security level
	       + FN_NameL(Upper(cProperty),16)  // Property name

  // See  crtprop.prg for Upper(cProperty) discussion

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
