/*
 * File......: SCANPROP.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_ScaProp()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Scan Property
 *  $SYNTAX$
 *
 *     FN_ScaProp(cObjectName, nObjectType, cProperty) => aPropInfo
 *
 *  $ARGUMENTS$
 *
 *     <cObjectName> is the name of the Bindery Object that you are trying
 *	   to find properties for.  Wildcard characters are not allowed.
 *	   Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *	   describing the defined types are included in the NETTO.CH
 *	   header file.  Wildcard characters are not allowed.
 *
 *     <cProperty> is the string containing the name of the property
 *	   to search for.  A maximum of 15 characters and wildcard
 *	   characters may be used.
 *
 *  $RETURNS$
 *
 *     <aPropInfo>
 *
 *     Is an array which contains one or more elements, depending
 *     if wild cards are used, which have seven values each.
 *
 *     aPropInfo[x,1] is name of the objects property.
 *
 *     aPropInfo[x,2] is true if the property is a set and false if
 *			the property is an item.
 *
 *     aPropInfo[x,3] is true if the property is dynamic and false
 *			if property is static.
 *
 *     aPropInfo[x,4] is the Property write security as an integer.
 *                      The integer indicates who can change the
 *                      property.
 *
 *     aPropInfo[x,5] is the Property read security as an integer.
 *			The integer indicates who can read and scan
 *                      for the property.
 *
 *           Ŀ
 *            Read and Write Security Levels  
 *           Ĵ
 *            0 Anyone                       
 *           Ĵ
 *            1 Logged                       
 *           Ĵ
 *            2 Object                       
 *           Ĵ
 *            3 Supervisor                   
 *           Ĵ
 *            4 Netware Operating System     
 *           
 *
 *     aPropInfo[x,6] is true if the property has value.
 *
 *     aPropInfo[x,7] return value from FN_rdproval if the property
 *			has value.
 *
 *
 *  $DESCRIPTION$
 *
 *     This function lets you scan the bindery for an object's properties.
 *     A wild card can be used for the property parameter.  The return value
 *     will be a multidimentional array in which each element will contain an
 *     array of values cooresponding to each property found.  If no
 *     properties are found or an error occurs, nil will be returned.
 *
 *     This function requires FT_IsBit() and FN_rdproval
 *
 *  $EXAMPLES$
 *
 *     aProperties := fn_scaprop("EVERYONE", OT_USER_GROUP, "*")
 *     QOut(aProperties[1]) //result  GROUP_MEMBERS
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"
#define NW_LOG     227

#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cProperty)
  LOCAL aProperties
    DEFAULT cObject TO "EVERYONE"
    DEFAULT nType   TO "2"  // OT_USER_GROUP
    DEFAULT cProperty TO "*"   // all properties

    aProperties := FN_ScaProp(cObject, Val(nType), cProperty)

    QOut("Property Name   IsSet IsDyn     Write     Read HasValue")
    Aeval(aProperties, {|aObj| Qout(aObj[1],aObj[2],aObj[3],aObj[4],aObj[5],aObj[6])})

    Qout(fn_error())

  RETURN ( nil )
#endif

FUNCTION FN_ScaProp(cObject, nType, cProperty)
  LOCAL cReceive    := Space(24)
  LOCAL aProperties := {}
  LOCAL cSend := I2BYTE(60);		     // 3Ch API Request Code
	     + W2HILO(nType);		     // Object Type
	     + fn_NameL(cObject,48);	     // Object Name
	     + L2HILO(-1);  // set sequence numer to -1 first time thru loop
	     + fn_NameL(Upper(cProperty),16) // Property Name

	    // See  crtprop.prg for Upper(cProperty) discussion

  DO WHILE ( _fnReq(NW_LOG, cSend, @cReceive) ) == ESUCCESS

    Aadd(aProperties, {;
    fn_noNull(Left(cReceive,16));        // property name
        , ft_IsBit(Substr(cReceive,17,1),1);       // is item or set
        , ft_IsBit(Substr(cReceive,17,1),0);       // is static or dynamic
        , Int(BYTE2I(Substr(cReceive,18,1))/16);   // property_write_security
        , Int(BYTE2I(Substr(cReceive,18,1)) % 16); // property_read_security
        , Substr(cReceive,23,1) == Chr(255);       // property_has_value
        , Fn_rdProVal(cObject, nType, Left(cReceive,16))})  // get the value

    // replace sequence number with last one received
    cSend := Stuff(cSend, 53, 4, Substr(cReceive,19,4))

  ENDDO

  IF FN_Error() == NO_SUCH_PROPERTY .AND. !Empty(aProperties)
      // Error is 251 when there are no more properties to search
      // This is ok, as long as we found at least one.
      _fnSetErr(ESUCCESS)
  ELSE
      // if no Properties found, or a different error occured, return nil
      aProperties := nil
  ENDIF

RETURN aProperties
