/* HILITE.C - HILITE(t,l,b,r,Color)   [Color can be String or #]      */
/* by Michael Smith - October, 1989                                   */
/*                                                                    */
/* For Clipper '87.  Change the Attributes of a block of the screen.  */
/* Uses dBase III+ Format Color codes and transforms it to an int     */
/* format.                                                            */
/*                                                                    */
/* Contains _db3clr2int() which will convert a dBase III/Clipper      */
/* color string (like W+/B) into an integer containing the attributes */
/* which are required when writing directly to the screen and setting */
/* the colors in a BASIC type format.                                 */

#include <nandef.h>
#include <extend.h>
#include <clipper.h>

/* Define Color Codes */
#define BLACK   0
#define BLUE    0x100
#define GREEN   0x200
#define CYAN    0x300
#define RED     0x400
#define MAGENTA 0x500
#define YELLOW  0x600
#define WHITE   0x700
#define BLINK   0x8000                  /* | this for blink */

/* Define Macros for Colors */
#define FORE(x) (x)
#define BACK(x) (0x7000 & ((x)<<4))     /* puts Color into bkgrd bits */
#define HI(x)   ((x) | 0x800)           /* adds hi intensity */

/* Define Screen Address's */
#define MONODMA         0xB000
#define COLORDMA        0xB800
#define MONOCARD        0x03B4

int __db3clr2int(byte *String, int _length) ;

/* Format - Hilite(top, left, bottom, right, color)  */
CLIPPER Hilite()
{
     int t, l, b, r, vidcard ;
     register int x,y ;
     unsigned far *scrp;
     unsigned __Color ;
     unsigned __screenseg=0xB800;

   /* Initialize the Screen Segment Variable */
     vidcard = *((int far *) MK_FP(0x40,0x63));
     __screenseg = (vidcard==MONOCARD) ? MONODMA : COLORDMA;

   /* Must be at least 5 parameters */
     if (PCOUNT < 5) return ;

   /* Get the Parameters from Clipper */
     t = _parni(1) ;
     l = _parni(2) ;
     b = _parni(3) ;
     r = _parni(4) ;

   /* Check Top, Left, Right, & Bottom for valid numbers */
     if (t < 0 || t > 24 || l < 0 || l > 80 || r < 0 || r > 80 || b < 0 || b > 24) return ;
     if (ISCHAR(5) && _parclen(5) != 0)
          __Color = __db3clr2int(_parc(5),_parclen(5)) ;
     else if (ISNUM(5)) __Color = _parni(5) ; else return ;

   /* Change Attributes of a block on the screen */
     for(x = t ; x <= b ; y = 0) {
          y = 0 ;
          for(scrp=MK_FP(__screenseg,(((x)*160)+((l)<<1)));
               (y <= r - l);
               y++,scrp++)
               *scrp=(__Color|(*scrp&0xff)) ;
          x++ ;
     }
     _retnd(__Color) ;
}
/*             y++,scrp++)
               *scrp=(__Color|(*scrp&0xff)) ;
*/
int __db3clr2int(byte *String,int _length)
{
     int x ;
     unsigned int __Color ;
     __Color = 0 ;

  /* Convert the Color String to Upper Case */
     for (x = 0; x <= _length;String[x] = toupper(String[x]), x++) ;

     x = 0 ;
  /* Work on the First part of the color string (before '/') */
     if (String[x] == 43 || String[x] == 42) x++ ;
     if (String[x] == 43 || String[x] == 42) x++ ;

     switch (String[x])
     {
          case (82) : __Color = FORE(RED)   ; break ; /* R */
          case (66) : __Color = FORE(BLUE)  ; break ; /* B */
          case (78) : __Color = FORE(BLACK) ; break ; /* N */
          case (71) : __Color = FORE(GREEN) ; break ; /* G */
          default   : __Color = FORE(WHITE) ; break ;
     }

  /* If the next byte is not '/', '+', or '*', then see if colors */
  /* like BG, RB, or GR.                                          */
     if (String[x+1] != 47 && String[x+1] != 43 && String[x+1] != 42 )
     {
        switch (String[x]+String[x+1])
        {
             case (137) : __Color = __Color | FORE(CYAN)    ; break ; /* BG */
             case (148) : __Color = __Color | FORE(MAGENTA) ; break ; /* RB */
             case (153) : __Color = __Color | FORE(YELLOW) ; break ; /* GR */
             default   : __Color = __Color | FORE(WHITE)   ; break ;
        }
        x = x + 2 ;
        if (String[x+1] == 47 ) x++ ; /* Move up 1 more if = '/' */
     } else x++ ;

  /* If the next byte is '/', '+', or '*' move up 1     */
     if (String[x+1] == 47 || String[x+1] == 43 || String[x+1] == 42) x++ ;
     if (String[x+1] == 47 || String[x+1] == 43 || String[x+1] == 42) x++ ;

   /* Set Background Color */
     switch (String[x+1])
     {
          case (87) : __Color = __Color | BACK(WHITE) ; break ;
          case (66) : __Color = __Color | BACK(BLUE) ; break ;
          case (78) : __Color = __Color | BACK(BLACK) ; break ;
          case (71) : __Color = __Color | BACK(GREEN) ; break ;
          default   : __Color = __Color | BACK(RED) ; break ;
     }
   /* Set Background Color (2nd character) */
   /* BG, RB, or GR.                       */
     switch (String[x+2])
     {
          case (66) : __Color = __Color | BACK(MAGENTA) ; break ;
          case (71) : __Color = __Color | BACK(CYAN) ; break ;
          case (82) : __Color = __Color | BACK(YELLOW) ; break ;
          default   : break ;
     }
   /* Is a '+' in the first 4 characters, if YES, then Brite Foreground */
     for (x=0; x <=3 ;) {
          if(String[x] == 43)  __Color = HI(__Color) ;
          x++ ;
     }

   /* Is a '*' in the first 4 characters, if YES, then Blink Foreground */
     for (x=0; x <=3 ;) {
          if(String[x] == 42)  __Color = __Color | BLINK ;
          x++ ;
     }

     return __Color ;
}
