/*********************************************************************
*  CLIPPER.H
**********************************************************************
*  Declares External Functions located in CLIPPER.LIB
*  Defines Constants which can be used in UDF's
*  Defines Macro's.
**********************************************************************/

/*********************************************************************/
/* MIN and MAX macros                                                */
/*********************************************************************/
#define MAX(a,b)    (((a) > (b)) ? (a) : (b))
#define MIN(a,b)    (((a) < (b)) ? (a) : (b))

/*********************************************************************/
/* Declare Macros for Data Conversion & Testing                      */
/*********************************************************************/
#define isalpha(p)   (('A'<=(p)&&(p)<= 'Z')||('a'<= (p)&&(p)<='z'))
#define isdigit(p)   ('0'<=(p)&&(p)<='9')

#define isspace(p)   (((p) == ' ')||((p) == '\n')||((p) == '\t')||\
                       ((p) == '\f')||((p) == '\r'))

#define islower(p)   ( 'a' <= (p) && (p) <= 'z' )
#define isupper(p)   ( 'A' <= (p) && (p) <= 'Z' )

#define toupper(p)   ( islower(p) ? ((p) + ('A' - 'a')) : ((p)) )
#define tolower(p)   ( isupper(p) ? ((p) - ('A' - 'a')) : ((p)) )


/*********************************************************************/
/* Commands in Clipper's Library for Low Level file usage            */
/*********************************************************************/
int _topen(char *, int, ...) ;  /* See O_... for open modes */
int _tclose(int) ;
int _tlseek(int, long, int) ;
int _tread(int, char *, unsigned int) ;
int _twrite(int, char *, unsigned int) ;
int _tunlink(const char *);
int _tcreat(char *, int);
int _trename(const char *, const char *);

/*********************************************************************/
/* Declare math functions in Clipper.LIB                             */
/*********************************************************************/
extern double pow(double, double);
extern double log(double);
extern double log10(double);
extern double exp(double);

/*********************************************************************/
/* Declare String functions in Clipper.LIB                           */
/*********************************************************************/
extern char *strcpy(char *, const char *);
extern char *strcat(char *, const char *);
extern char *strncpy(char *, const char *, unsigned int);

/*********************************************************************/
/* Define Constants used in Memo Files (variable type)               */
/*********************************************************************/
#define VAR_CHAR    0xC3    /* Character Type Var in .MEM File */
#define VAR_DATE    0xC4    /* Date Type Var in .MEM File */
#define VAR_LOG     0xCC    /* Logical Type Var in .MEM File */
#define VAR_NUM     0xCE    /* Numeric Type Var in .MEM File */

/*********************************************************************/
/* Define Constants for Opening Files (2nd parameter)                */
/*********************************************************************/
#define O_RDONLY    0x0000  /* open for reading only */
#define O_WRONLY    0x0001  /* open for writing only */
#define O_RDWR      0x0002  /* open for reading and writing */
#define O_APPEND    0x0008  /* writes done at eof */
#define O_CREAT     0x0100  /* create and open file */
#define O_TRUNC     0x0200  /* open and truncate */
#define O_EXCL      0x0400  /* open only if file doesn't already exist */
#define O_TEXT      0x4000  /* file mode is text (translated) */
#define O_BINARY    0x8000  /* file mode is binary (untranslated) */

/*********************************************************************/
/* Declare Macros for Far Pointers, Offsets, & Segements             */
/*********************************************************************/
#define MK_FP(seg,ofs)  ((void far *) \
                         (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#define FP_OFF(fp)      ((unsigned)(fp))
#define FP_SEG(fp)      ((unsigned)((unsigned long)(fp) >> 16))

