/*********************************************************************/
/* GET_VAR.C - GET_VAR() Function for Clipper '87.                   */
/* by Michael Smith - October, 1989                                  */
/*********************************************************************/
/* Function to Search a Memo File for Variable and return back       */
/* its value.  It works well for Character, Logical, & Numerics,     */
/* but for dates you must perform the following:                     */
/*   CTOD("01/01/0100") + GET_VAR("FILE.MEM","IDATE") - 1757585      */
/*********************************************************************/
/* Based on Program from DOSS: Vol. 1, #22, by Essor Masso.          */
/*********************************************************************/

#include <nandef.h>
#include <extend.h>
#include <clipper.h>

/*********************************************************************/
/* Define My Functions for Use with Clipper's                        */
/*********************************************************************/
long __tell(int) ;       /* C_FILES1.ASM - Return Current Position */
long __tlen(int) ;       /* C_FILES2.C   - Return Length of File   */
int  __teof(int) ;       /* C_FILES2.C   - Return 1 if End-of-file */
long __tgeof(int) ;      /* C_FILES1.ASM - Goto the end of File    */

/*********************************************************************/
/* String Compare Function located in STRCMPN.C                      */
/*********************************************************************/
extern Boolean _Strcmpn(byte *String1, byte *String2, int length) ;

/*********************************************************************
 Parameters:
     Parm1 - File Name (Including Extension)
     Parm2 - Variable Name to Search for in file (IN UPPER CASE)
   [ Parm3 - Value to Return back if not found, default is NULL ]
**********************************************************************/

/*********************************************************************/
CLIPPER Get_Var()
/*********************************************************************/
{
     quant    V_Len ;
     int      File_Handle, _dummy_int ;
     register int x ;
     byte     *_Work, *Buffer, V_Name[11], V_Type[2], My_Buffer[50] ;
     char     *File_Name, *Variable ;
     double   Mantissa, Value ;
     Boolean  __FoundVar, __Minus ;

     __FoundVar = FALSE ;

   /* Check for Valid Parameters */
     if (PCOUNT >= 2 && ISCHAR(1) && ISCHAR(2)) {
          File_Name = _parc(1) ;
          Variable = _parc(2) ;
          _dummy_int = _parclen(2) ;

       /* Convert the Variable to Upper Case */
          for (x = 0; x <= _dummy_int;Variable[x] = toupper(Variable[x]), x++) ;

       /* Allocate memory for work space buffer */
          _Work = _exmgrab(20) ;
          if (_Work)
          {
             /* Open the Memo File as Read-Only & Binary */
               File_Handle = _topen(File_Name, O_RDONLY | O_BINARY) ;
               if (File_Handle != -1)
               {
                  /*  Go Thru the file variable-by-variable */
                    while (1)
                    {
                       /* Read 11 bytes into variable name */
                         _tread(File_Handle, V_Name,11) ;

                         if (__teof(File_Handle)) break ;

                       /* Read 1 bytes with the Var type */
                         _tread(File_Handle, V_Type,1) ;

                       /* Skip over 4 bytes */
                         _tread(File_Handle, _Work, 4) ;

                       /* Read Pointer Length into work */
                         _tread(File_Handle, _Work,2) ;

                       /* Move Binary Pointer Len into Integer */
                         V_Len = _Work[0] ;
                         V_Len = V_Len + _Work[1] * 256 ;

                       /* Skip over 14 bytes to get to variable contents */
                         _tread(File_Handle, _Work,14) ;

                     /*  _tlseek(File_Handle,__tell(File_Handle)+14,0) ; */

                         if (V_Type[0] == VAR_DATE || V_Type[0] == VAR_NUM) V_Len = 8 ;

                    /* Keep 50 Byte buffer available to use instead of */
                    /* calling _exmgrab() for every variable in the    */
                    /* .MEM file.                                      */

                         if (V_Len > 49) Buffer = _exmgrab(V_Len) ;
                         else Buffer = My_Buffer ;

                         if (Buffer)
                         {
                            /* Read in the Contents of the Variable */
                              _tread(File_Handle,Buffer,V_Len) ;

                            /* Call String compare function to see if */
                            /* it is the correct variable name        */
                              if (_Strcmpn(V_Name, Variable, _dummy_int))
                              {
                                   __FoundVar = TRUE ;
                                   break ;
                              }

                            /* If Not Using My_Buffer, give back memory */
                              if (V_Len > 49) _exmback(Buffer,V_Len) ;

                         } /* ENDIF Buffer */
                    }  /* ENDWHILE */
               } /* ENDIF - File_Handle != -1 */
               _exmback(_Work,20) ;
               _tclose(File_Handle) ;
          } /* ENDIF -!_exmgrab(20) */
     } /* ENDIF - Valid Parameters */

     if (__FoundVar)
     {
          if (V_Type[0] == VAR_NUM || V_Type[0] == VAR_DATE)
          {
          /* Convert 8 byte IEEE value to a double */
               Value = (Buffer[7] % 128) * 16 ;
               _dummy_int = Value + (Buffer[6]/16) - 1023 ;
               if ((Buffer[7]/16) >= 8) __Minus = 1 ; else __Minus = 0 ;

               Mantissa = (float)(Buffer[6] % 16) /16 ;

               Value = Buffer[4] ;
               Value = Value + Buffer[5] * 256 ;
               Mantissa = Mantissa + Value/(65536 * 16) ;

               Value = Buffer[2] ;
               Value = Value + Buffer[3] * 256 ;
               Mantissa = Mantissa + Value/(pow(65536,2) * 16) ;

               Value = Buffer[0] ;
               Value = Value + Buffer[1] * 256 ;
               Mantissa = Mantissa + Value/(pow(65536,3) * 16) ;

               Value = (1 + Mantissa) * pow(2.0, _dummy_int) ;

               if (__Minus) Value = -1 * Value ;
          }
          switch (V_Type[0])
          {
               case (VAR_LOG) :
                    _retl(Buffer[0]) ;
                    break ;
               case (VAR_NUM) :
                    _retnd(Value) ;
                    break ;
               case (VAR_DATE) :
                    _retnd(Value) ;
                    break ;
               default :   /* case (VAR_CHAR) : */
                    _retclen(Buffer,V_Len - 1) ;
                    break ;
          }
          if (V_Len > 49) _exmback(Buffer,V_Len) ;
     }
     else
     {
          switch (_parinfo(3))
          {
               case (CHARACTER) :
                    _retc(_parc(3)) ;
                    break ;
               case (NUMERIC) :
                    _retnd(_parnd(3)) ;
                    break ;
               case (LOGICAL) :
                    _retl(_parl(3)) ;
                    break ;
               default :
                    _retc("") ;
                    break ;
          }
     } /* IF __FoundVar */
}

/* End of GETVAR.C */
