// These #defines use the browse's "cargo" slot to hold the
// flags and other information for the browse. 

// Append mode flag
#define SET_ALLOW_APPEND(b,l)       b:cargo[1] := l
#define ALLOW_APPEND_MODE(b)        b:cargo[1]

// get on return flag
#define SAVE_RETURN_ACTION(b,a)     b:cargo[2] := a
#define RETURN_ACTION(b)            b:cargo[2]

// the while condition
#define SAVE_WHILE_BLOCK(b,block)   b:cargo[3] := block
#define WHILE_BLOCK(b)              b:cargo[3]

// the seek key for the while condition
#define SAVE_SEEK_KEY(b,key)        b:cargo[4] := key
#define SEEK_KEY(b)                 b:cargo[4]

// the width of the frozen columns
#define SAVE_FREEZE_WIDTH(b,a)      b:cargo[5] := a
#define FREEZE_WIDTH(b)             b:cargo[5]

// The current record number (n of m total meeting while condtion)
// not the value returned by RECNO()
#define SAVE_RECORD_NUM(b,a)        b:cargo[6] := a
#define RECORD_NUM(b)               b:cargo[6]

// the total number of records meeting the while condition
#define SAVE_TOTAL_COUNT(b,a)       b:cargo[7] := a
#define TOTAL_COUNT(b)              b:cargo[7]

// the vertical scroll bar information
#define SAVE_VERT_SCROLL(b,a)       b:cargo[8] := a
#define VERT_SCROLL(b)              b:cargo[8]

// the horizontal scroll bar information
#define SAVE_HORIZ_SCROLL(b,a)      b:cargo[9] := a
#define HORIZ_SCROLL(b)             b:cargo[9]

// array of the cumulative widths of all columns
#define SAVE_TOTAL_WIDTH(b,i,a)     b:cargo[10][i] := a
#define TOTAL_WIDTH(b)              b:cargo[10]

// The number of rows used by the heading information
#define SAVE_HEADING_DEPTH(b,a)     b:cargo[11] := a
#define HEADING_DEPTH(b)            b:cargo[11]

// The append reader code block
#define SAVE_APPEND_BLOCK(b,a)      b:cargo[12] := a
#define APPEND_BLOCK(b)             b:cargo[12]

// the action on double click
#define SAVE_DOUBLE_CLICK(b,l)      b:cargo[13] := l
#define DOUBLE_CLICK(b)             b:cargo[13]

// the caller's procedure name for passing to a SET KEY function
#define SAVE_PROC_NAME(b,c)          b:cargo[14] := c
#define PROC_NAME(b)                 b:cargo[14]

// The caller's procedure line for passing to a SET KEY function
#define SAVE_PROC_LINE(b,c)          b:cargo[15] := c
#define PROC_LINE(b)                 b:cargo[15]

#define SAVE_ALT_READER(b,c)         b:cargo[16] := c
#define ALT_READER(b)                b:cargo[16]

#define B_CARGO_SIZE                16   && equal to the last reference above

// column cargo use definitions

// individual column allow edit flags
#define SAVE_ALLOW_EDIT(c,l)        c:cargo[1] := l
#define ALLOW_EDIT(c)               c:cargo[1]

// column picture strings
#define SAVE_PICTURE(c,ch)          c:cargo[2] := ch
#define GET_PICTURE(c)              c:cargo[2]

// column when cblock
#define SAVE_WHEN(c,b)              c:cargo[3] := b
#define GET_WHEN(c)                 c:cargo[3]

// column valid block
#define SAVE_VALID(c,b)             c:cargo[4] := b
#define GET_VALID(c)                c:cargo[4]

#define C_CARGO_SIZE               4   // equal to the last element above

#define NO_GET             0
#define GET_ON_RETURN      1
#define DOUBLE_CLICK_GET   4

#define REFRESH_CURRENT    1
#define REFRESH_ALL        2
