* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*   listfile.prg                                                            *
*                                                                           *
*   Phil Hill                                                               *
*   Gainesville, FL                                                         *
*   12/01/88                                                                *
*                                                                           *
*   08/09/89 - Modified to eliminate screen clearing between pages.         *
*                                                                           *
*   Allows a text file (specified by the parameter File2List) to            *
*   be listed to the screen with forward and reverse paging. The            *
*   width of the display is fixed at 78 characters.  Any text               *
*   past 78 will be truncated.                                              *
*                                                                           *
*   calling syntax:  DO listfile WITH <filename>                            *
*                                                                           *
*   Beeps and returns to the calling program if:                            *
*         1) The specified file doesn't exist, or                           *
*         2) If txtfile.dbf can't be found.                                 *
*                                                                           *
*   Structure for database: txtfile.dbf                                     *
*                                                                           *
*         Field  Field Name  Type       Width                               *
*         ----- -----------  ---------  -----                               *
*             1  LINE        Character     78                               *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*-- Code starts.
PARA File2List
PRIV kp, PrevLine, NumLines, nul

*-- Make sure the files exist.
IF .NOT. FILE(File2List) .OR. .NOT. FILE("txtfile.dbf")
   ?? CHR(7)
   RETURN
ENDIF

*-- Housekeeping.
*   Suggest turning the cursor off here via cursoff.bin or usual method.
SET TALK OFF
SET SCOREBOARD OFF
SET SAFETY OFF
SET ESCAPE OFF
SET HEADING OFF

*-- Set up the opening screen.
CLEAR
SET COLOR TO I
@  0,  1 SAY SPACE(78)
@  0, 25 SAY "[ Viewing file: &File2List. ]"
@ 24,  1 SAY SPACE(78)
@ 24, 16  SAY "[ Use:  <PgDn>  " + CHR(17) + CHR(16) + "  <PgUp>  " +;
              CHR(17) + CHR(16) + "  <Esc> to Quit ]"
SET COLOR TO W+
@ 10, 30 SAY "Loading &File2List...."

*-- Read the text file into the dbf.
USE txtfile
ZAP
APPEND FROM &File2List SDF
GO TOP

*-- Initialize some memvars.
NumLines = RECCOUNT()
PrevLine = 0
nul = ""

*-- Display the first screen of text.
SET COLOR TO 
@ 10, 30
@  0,  0 SAY M->nul
LIST NEXT 23 line OFF
@ 23, 79 SAY M->nul

DO WHILE .T.
   *-- Wait for a keypress, unless this is the very first screen.
   kp = 0
   DO WHILE M->kp = 0
      kp = INKEY()
   ENDDO

   *-- A key was pressed.  See if action is required.
   DO CASE
      CASE M->kp = 18 .AND. M->PrevLine - 23 > 0
           *-- <PgUp> go back one screenful.
           GO M->PrevLine - 23
      CASE M->kp = 27
           *-- <Esc> is the only way out.
           EXIT
      CASE M->kp <> 3 .OR. M->PrevLine = M->NumLines .OR. EOF()
           *-- Invalid key, or no more screens.  Could add a beep here.
           LOOP
      OTHERWISE
           SKIP
   ENDCASE

   *-- <PgDn> must have been pressed, to make it this far.
   PrevLine = RECNO()

   *-- Display the new screen of text.
   @  0,  0 SAY M->nul
   LIST NEXT 23 line OFF
   IF ROW() < 23
      IF COL() > 0
         ?
      ENDIF
      @ ROW(), 0 CLEAR TO 23, 79
   ENDIF
   @ 23, 79 SAY nul
ENDDO

*-- Do some housekeeping, then return to the calling program.
*   Turn on anything else that's normally on here.
ZAP
CLOSE DATABASES

SET HEADING ON
SET ESCAPE ON

*-- If it's off, turn the cursor back on here.
CLEAR

RETURN
* ==========================  EOF listfile.prg  =========================== *
