* Program.: LIST.PRG
* Author..: Brian Russel
* Date....: 06/20/85
* Notes...: Simulates the raw form of the dBASE LIST command.  Pass
*           the file to be LISTed on the DOS command line.
*              A:LIST <fiLEName>

* Get file to use.
PARAMETER file
file = UPPER(TRIM(file)) + ".DBF"
IF .NOT. FILE("&file")
   ? file + " not found"
   RETURN
ENDIF

USE &file
* Display field name header.
f = 1
? "Record#  "
DO WHILE "" <> FIELD(f)
   field = FIELD(f)
   DO CASE
      CASE TYPE("&field") = 'C'
         LEN = LEN(&field)
      CASE TYPE("&field") = 'N'
         LEN = LEN(str(&field))
      CASE TYPE("&field") = 'D'
         LEN = LEN(DTOC(&field))
      CASE TYPE("&field") = 'L'
         LEN = 1
   ENDCASE
   ?? SUBSTR(field + SPACE(80), 1, LEN) + ' '
   f = f + 1
ENDDO

*Display data.
DO WHILE .NOT. EOF()
   ? RECNO(), IF(DELETED(), "*", " ")
   f = 1
   DO WHILE "" <> field(f)
      field = FIELD(f)
      ?? &field
      ?? ' '
      f = f + 1
   ENDDO
   SKIP
ENDDO

*EOF:LIST.PRG
