#include <stdio.h>
#include <stdlib.h>
#include <string.h>


void main( int, char**);
int t_blank( char *, int);


void main( argc, argv)
register int argc;
char *argv[];
{
	FILE *fp;
	register int i;
	char err_msg[80], line_buf[161], ext[_MAX_EXT], *ptr;
	char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME + _MAX_EXT];
	unsigned total_code = 0, total_comments = 0, total_blanks = 0;
	unsigned file_code, file_comments, file_blanks, num_files = 0;
	double total;


	if ( argc < 2 ) {
		printf("\nFormat is: LINECNT <file1> [<file2>] ... [<filex>]\n");
		return;
	}

	for ( i = 1; i < argc; i++) {

		file_code = file_comments = file_blanks = 0;

		if ( !(fp = fopen( argv[i], "rt")) ) {
			sprintf( err_msg, "\nUnable to open %s", argv[i]);
			perror(err_msg);
			continue;
		}

		while ( fgets( line_buf, 160, fp) ) {

			if ( t_blank( line_buf, 1) )
				file_blanks++;
			else if ( line_buf[0] == '#' )
				file_comments++;
			else if ( ptr = strchr( line_buf, '*') ) {
				*ptr = '\0';
				if ( t_blank( line_buf, 1) )
					file_comments++;
				else
					file_code++;
			} else
				file_code++;
		}

		if ( ferror(fp) ) {
			sprintf( err_msg, "\nError reading %s", argv[i]);
			perror(err_msg);
			fclose(fp);
			continue;
		}

		fclose(fp);

		_splitpath( argv[i], drive, dir, fname, ext);
		total = (double) (file_code + file_blanks + file_comments);

		printf("\n%-12s    Blank Lines = %5u  %5.1f%%    Comment Lines =  %5u  %5.1f%%",
				strupr( strcat( fname, ext)),
				file_blanks, (double) ((file_blanks / total) * 100.0),
				file_comments, (double) ((file_comments / total) * 100.0));

		printf("\n                 Code Lines = %5u  %5.1f%%      Total Lines = %6.0f\n",
				file_code, (double) ((file_code / total) * 100.0), total);

		total_code += file_code;
		total_blanks += file_blanks;
		total_comments += file_comments;
		num_files++;
	}

	if ( num_files ) {
		total = (double) (total_code + total_blanks + total_comments);

		printf("\n\nAll Files       Blank Lines = %5u  %5.1f%%    Comment Lines =  %5u  %5.1f%%",
				total_blanks, (double) ((total_blanks / total) * 100.0),
				total_comments, (double) ((total_comments / total) * 100.0));
		printf("\nFiles = %3d      Code Lines = %5u  %5.1f%%      Total Lines = %6.0f\n",
				num_files, total_code,
				(double) ((total_code / total) * 100.0), total);
	}
}


int t_blank( string, whitespace)
char  *string;
int whitespace;
{
	register int  i, j = strlen(string);


	for ( i = 0; i < j; i++ )
		if ( !(string[i] == ' ' ||
				(whitespace && (string[i] == '\011' || string[i] == '\n'))) )
			return(0);

	return(1);
}
