*---------------------------------------------------------------------------
*
* Demo for Light & Dark, Copyright (c) 1993,1994 DataEnter, Michael Kocum
*
*---------------------------------------------------------------------------
#include "LD.CH"
#include "INKEY.CH"
*---------------------------------------------------------------------------
FUNCTION MAIN()
memvar getlist
LOCAL nTyp,nPrinter,aCode,cText,ni,cPreBar,nWidth
*
SET SCOREBOARD OFF
*
SETCOLOR(COLORSET(3))
@ 0,0 SAY PADR(" Light & Dark                 Copyright (c) 1993,1994  DataEnter, Michael Kocum",80)
@ 24,0 SAY PADR(" " + LDVersion(),80)
SETCOLOR(COLORSET(2))
@ 1,0,23,79 BOX  ""
SETCOLOR(COLORSET(1))
*
SIMPLEBOX(.T.,3,5,12,43)
DO WHILE .T.
   @  5, 7 SAY " Select printer:"
   @  5,24 PROMPT " Epson  9pin     "
   @  6,24 PROMPT " Epson 24pin     "
   @  7,24 PROMPT " IBM Graphic     "
   @  8,24 PROMPT " HP Laserjet     "
   @  9,24 PROMPT " HP Deskjet      "
   @ 10,24 PROMPT " HP Deskjet Plus "
   MENU TO nPrinter
   *
   IF LASTKEY() == K_ESC
      exit
   ENDIF
   SIMPLEBOX(.T.,7,10,18,44)
   DO WHILE .T.
      @  9,12 SAY " Select Barcode:"
      @  9,29 PROMPT " EAN 8       "
      @ 10,29 PROMPT " EAN 13      "
      @ 11,29 PROMPT " UPC 12      "
      @ 12,29 PROMPT " 3/9         "
      @ 13,29 PROMPT " 2/5 Int     "
      @ 14,29 PROMPT " CodaBar     "
      @ 15,29 PROMPT " 93          "
      @ 16,29 PROMPT " Code-128    "
      MENU TO nTyp
      IF LASTKEY() == K_ESC
         exit
      ENDIF
      *
      * now generate PreCode
      *
      DO CASE
      CASE nTyp == 1          && EAN 8

         cPreBar := LDEAN8("50123452")
         cText   := "EAN 8"
         nWidth  := 15

      CASE nTyp == 2          && EAN 13

         cPreBar := LDEAN13("4974365610098")
         cText   := "EAN 13"
         nWidth  := 20

      CASE nTyp == 3          && UPC 12

         cPreBar := LDUPC12("123456789012")
         cText   := "UPC 12"
         nWidth  := 20

      CASE nTyp == 4          && 3/9

         cPreBar := LD39("MICHAEL")
         cText   := "3/9"
         nWidth  := 22

      CASE nTyp == 5          && 2/5 Int

         cPreBar := LD25Int("12345")
         cText   := "2/5 Int"
         nWidth  := 15

      CASE nTyp == 6          && CodaBar

         cPreBar := LDCodaBar("12345")
         cText   := "CodaBar"
         nWidth  := 15

      CASE nTyp == 7          && 93

         cPreBar := LD93("Code 93" + LD93ChkDigit("Code 93"))
         cText   := "93"
         nWidth  := 20

      CASE nTyp == 8          && Code-128

         cPreBar := LD128A("CODE 128" + LD128AChkDigit("CODE 128"))
         cText   := "Code-128"
         nWidth  := 15

      ENDCASE
      *
      * Generate code array for specific printer
      *
      DO CASE
      CASE nPrinter == 1   && Epson 9pin

         aCode := LDGenerate(LD_TYP_EPSON9,cPreBar,nWidth,3,5)

      CASE nPrinter == 2   && Epson 24pin

         aCode := LDGenerate(LD_TYP_EPSON24,cPreBar,nWidth,3,5)

      CASE nPrinter == 3   && IBM Graphic

         aCode := LDGenerate(LD_TYP_IBM9,cPreBar,nWidth,3,5)

      CASE nPrinter == 4   && Laserjet

         aCode := LDGenerate(LD_TYP_PCL4,cPreBar,nWidth,3,5)

      CASE nPrinter == 5   && Deskjet

         aCode := LDGenerate(LD_TYP_PCL3,cPreBar,nWidth,3,5)

      CASE nPrinter == 6   && Deskjet Plus

         aCode := LDGenerate(LD_TYP_PCL3ENH,cPreBar,nWidth,3,5)

      ENDCASE
      *
      * Now print result
      *
      @ 24,0 SAY PADR("Printing to LPT1...",80)
      *
      SET CONSOLE OFF
      SET PRINTER TO LPT1
      SET PRINTER ON
      *
      ?
      ? Space(5) + LDVersion()
      ?
      ? Space(5) + "Sample printout of "  + cText
      ?
      ?
      ?
      ?
      for ni := 1 to len(aCode)
         ?? aCode[ni]
      next
      *
      ?
      *
      EJECT
      SET PRINTER OFF
      SET CONSOLE ON
      SET PRINTER TO
      *
      @ 24,0 SAY PADR(" " + LDVersion(),80)
      *
   ENDDO
   SIMPLEBOX(.F.)
ENDDO
SIMPLEBOX(.F.)
SET COLOR TO
CLEAR
QUIT
RETURN(NIL)
*---------------------------------------------------------------------------
FUNCTION COLORSET(nPos)
STATIC aColor := {"W/B,N/BG,N,N,GR+/B","W+/B","N/BG"}
STATIC aMono  := {"W/N,N/W,N,N,W+/N","W+/N","N/W"}
IF ISCOLOR()
   RETURN(aColor[nPos])
ENDIF
RETURN(aMono[nPos])
*---------------------------------------------------------------------------
FUNCTION SIMPLEBOX(lOpen,nTop,nLeft,nBottom,nRight)
STATIC aBox := {}
IF lOpen
   AADD(aBox,{nTop,nLeft,nBottom,nRight,SAVESCREEN(nTop,nLeft,nBottom,nRight)} )
   @ nTop,nLeft,nBottom,nRight BOX  "Ŀ "
ELSE
   RESTSCREEN(aBox[len(aBox)][1],aBox[len(aBox)][2],aBox[len(aBox)][3],;
   aBox[len(aBox)][4],aBox[len(aBox)][5])
   ASIZE(aBox,LEN(aBox)-1)
ENDIF
RETURN(NIL)
*---------------------------------------------------------------------------
