#include "FileIO.ch"


#define CRLF CHR(13) + CHR(10)
#define F_BLOCK 2048

/*
*   Routine: FileCount( <cFile>[, <cFindStr>] ) --> N
*          : 
*    Author: Written by Cai Campbell
*          : Compuserve I.D. 72622, 1771
*          : 
*   Purpose: used to count lines in a ascii file
*          : 
* Arguments: <cFile>        file to count lines in
*          :
*          : [<cFindStr>]   Hook for searching for text in <cFile>
*          :
*   Returns: Total lines in <cFile>
*          :
*  Comments: This copy has been modified from original version by KSG
*          : 
*/
function flinecount( cFile,cFindStr )
    local cFlushBuf := SPACE( F_BLOCK )
    local cBuffer   := cFlushBuf
    local nBytes    := F_BLOCK
    local nPos      := 0
    local nFoundAt  := 1
    local nNumLines := 0
    local nHandle

    nHandle := fopen(cFile,FO_READ)
    if .not. (ferror() == 0)
        return F_ERROR
    endif
    while nBytes == F_BLOCK
        nBytes := FREAD(nHandle,@cBuffer,nBytes)
        while !((nFoundAt := at(CRLF,substr(cBuffer,nPos,nBytes))) == 0)
            // KSG possible use for doing searching of text
            if !empty(cFindStr)
                if at(CRLF,substr(cBuffer,nPos,nBytes)) > 0
                    *
                    * Work with it
                    *
                    * substr(cBuffer,nPos,nFoundAt)
                    * if inkey(.2) == 27
                    *     fclose(nHandle)
                    *     quit
                    * endif
                    * 
                endif
            endif
            
            nPos      += nFoundAt + 1    
            nNumLines += 1
        enddo
        fseek(nHandle, -1,FS_RELATIVE)
        cBuffer := cFlushBuf
        nPos    := 0
    enddo
    fclose(nHandle)
return nNumLines
