
#include "error.ch"

#define F_ERROR -1

request transform

procedure main
    local cError  := "{|file,name| Kevin(file,name)}"
    local bErrHand:= errorblock({|e| break(e)})
    local oMy
    cls 

    /*
    * Here we show the danger of using macros since the
    * error does not appear until we call on the string
    * in the first call to filescan. We allow recovery
    * for this demo, otherwise you get booted to DOS.
    */
    begin sequence
        ?filescan("c:\windows\*.ini",,  &(cError)  )
        ??" bytes"
    recover using oMy
        if oMy:subsystem == "BASE" .and. oMy:subcode == 1001
            tone(400,1)
            tone(400,1)
            ?padr("ERROR",25),cError,oMy:description
            ?F_ERROR
            ??" bytes"
        else
            eval(bErrHand,oMy)
        endif
    end sequence
    errorblock(bErrhand)

    ?filescan("*.prg;C:\DOS\a*.exe;C:\*.*",,{|file,name| MyFunc(file,name)})
    ??" bytes"
    ?filescan("C:\BRIEF\*.*","HD",{|file,name| MyFunc(file,name)})
    ??" bytes"
return

function MyFunc(cFile,name)
    local cScrn
    local nRow
    local nCol
    local cColor
    local nRetVal := 1
    local aArray_
    local aUnder_ := {}

    // do not process [.] or [..] entries
    if !(left(cFile,1) == ".")
        aArray_ := directory(name + if( !("." $ name),"\*.*",""))
        ?padr(cFile,15),if(!empty(aArray_),aArray_[1,3],"        ")," "

        // show fullname in inverse colors if in the DOS directory
        if "\DOS\" $ name
            cColor := setcolor("I")
            ??name
            setcolor(cColor)
        else
            ??name
        endif

        // show files under <name> if <name> is a valid directory
        if ft_isdir(name)
            aeval(aArray_,{|a| aadd(aUnder_,a[1])})
            if !empty(aUnder_)
                ShowDirs(aUnder_,name)
            endif
        endif

        // get total lines in these ascii files only
        if ".PRG" $ cFile .or. cFile == "AUTOEXEC.BAT"
            // count lines in cFile
            ??"",ltrim(transform(flinecount(name),"999,999,999")),"lines"
        endif

        // use memoedit to view file - no edit mode
        if cFile == "ISFILE.PRG" .or. cFile == "CONFIG.SYS"
            if alert("View " + cFile,{"Yes","No"}) == 1
                nRow  := row()
                nCol  := col()
                cScrn := savescreen(0,0,maxrow(),maxcol())
                cColor:= setcolor("w+/b")
                dispbox(0,0,maxrow(),maxcol())
                @0,1 say ;
                "< When done viewing '" + lower(cFile) + "' press ESC >"
                memoedit(memoread(name),1,1,maxrow() -1,maxcol() -1,.f.)
                setcolor(cColor)
                restscreen(0,0,maxrow(),maxcol(),cScrn)
                setpos(nRow,nCol)
            endif
        endif
        // slight pause so we do not scroll off the console.
        inkey(.4)
    endif
return nRetVal

/*
*   Routine: ShowDirs( <aUnder_>, <name> )
*          : 
*   Purpose: used for demoing purposes
*          : 
*  Comments: Very crude method to show files, the title
*          : may extend passed the box coordinates!
*          : Being real lazy and save entire screen.
*          : 
*/
static procedure ShowDirs(aUnder_,name)
    local cScrn := savescreen()
    local nRow  := row()
    local nCol  := col()
    local cColor:= setcolor("w+/rb,w+/b")
    dispbox(0,0,10,20,'ͻȺ ')
    @0,1 say name

    // Everyone's got achoice!
    achoice(1,1, 9,19,aUnder_)

    setcolor(cColor)
    restscreen(0,0,maxrow(),maxcol(),cScrn)
    setpos(nRow,nCol)
return

